<head>
    {{-- TÍTULO DINÂMICO --}}
    <title>SafetyStart - Login</title>
</head>

<x-guest-layout>
    <x-jet-authentication-card>

        <x-slot name="logo">
            <img src="img/logos.png">
        </x-slot>

        <div class="mb-8 text-center">
            <h1 class="text-2xl font-bold text-white">Bem-vindo(a) ao SafetyStart</h1>
            <p class="text-gray-300 mt-2">Sua ferramenta para um ambiente de trabalho mais seguro.</p>
        </div>
        <x-jet-validation-errors class="mb-4" />

        @if (session('status'))
            <div class="mb-4 font-medium text-sm text-green-600">
                {{ session('status') }}
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf
            
            <div>
                <label for="email" class="block text-sm/6 font-semibold text-white">SAP ID</label>
                <div class="mt-2.5">
                    <input id="email" type="text" name="email" placeholder="Digite seu SAP ID" :value="old('email')" required autofocus class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600">
                </div>
            </div>

            <div class="mt-4">
                <label for="password" class="block text-sm/6 font-semibold text-white">Matrícula</label>
                <div class="mt-2.5">
                    <x-jet-input id="password" placeholder="Digite sua Matrícula" type="text" name="password" required autocomplete="current-password" class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600" />
                </div>
            </div>

            <div class="mt-4">
                <div class="flex items-center justify-end mt-4">
                    @if (Route::has('password.request'))
                    <a class="underline text-sm text-white hover:text-white" href="{{ route('password.request') }}">
                        {{ __('Precisa de ajuda?') }}
                    </a>
                    @endif
                </div>
            </div>
            
            <div class="flex items-center justify-center mt-4">
                <x-jet-button class="ml-4 bg-cyan">
                    {{ __('ENTRAR') }}
                </x-jet-button>
            </div>
        </form>
        
        {{--<span class="flex items-center justify-center mt-10 text-white">É seu primeiro acesso?</span>
        <div class="flex items-center justify-center mt-2">
            <x-jet-button class="ml-4 bg-yellow">
                @if (Route::has('register'))
                    <a href="{{ route('register') }}">
                        {{ __('CLIQUE AQUI') }}
                    </a>
                @endif
            </x-jet-button>
        </div>--}}

        <div align="center" class="mt-5">
            <img src="img/sipat_logo.png" class="mt-5" width="150px">
            <img src="img/safetystart_logo.png" class="mt-5" width="100px">
        </div> <div class="mt-8 pt-4 border-t border-gray-600 text-center">
            <p class="text-xs text-gray-400">
                Este é um aplicativo de uso exclusivo para empregados Stellantis das unidades de Betim Veículos, PWT e Mopar.
            </p>
        </div>
        </x-jet-authentication-card>
</x-guest-layout>