@extends('layouts.main')

@section('title', 'SafetyStart - Meu usuário')

@section('content')
@php
    /** @var \App\Models\User|null $user */
    $user = auth()->user();
    $initials = collect(explode(' ', trim($user?->name ?? '')))
                    ->filter()
                    ->map(fn($p) => mb_substr($p, 0, 1))
                    ->take(2)->implode('') ?: 'U';
@endphp

    <!-- CONTEÚDO -->
    <section id="content">
        
        <!-- CARD DO PERFIL -->
        <div class="bg-white" style="border-radius:20px; box-shadow:0 6px 24px rgba(0,0,0,.08); padding:28px;">
            <div class="m-b-40">
                <h1 class="titleItems">Meu Usuário</h1>
            </div>


            <!-- Grid dos campos -->
            <div style="display:grid; grid-template-columns: repeat(12, 1fr); gap:16px;">
                <!-- Nome -->
                <div style="grid-column: span 12;">
                    <label class="block font-medium text-sm text-gray-700">Nome</label>
                    <input type="text" readonly
                        value="{{ $user?->name ?? '—' }}"
                        class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600"
                        style="background:#f5f5f5;border-radius:12px;">
                </div>

                <!-- SAP ID -->
                <div style="grid-column: span 3;">
                    <label class="block font-medium text-sm text-gray-700">SAP ID</label>
                    <input type="text" readonly
                        value="{{ $user?->email ?? '—' }}"
                        class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600"
                        style="background:#f5f5f5;border-radius:12px;">
                </div>

                <!-- SAP ID -->
                <div style="grid-column: span 3;">
                    <label class="block font-medium text-sm text-gray-700">Matrícula</label>
                    <input type="text" readonly
                        value="{{ $user?->matricula ?? '—' }}"
                        class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600"
                        style="background:#f5f5f5;border-radius:12px;">
                </div>

                <!-- Empresa -->
                <div style="grid-column: span 3;">
                    <label class="block font-medium text-sm text-gray-700">Empresa</label>
                    <input type="text" readonly
                        value="{{ $user?->empresa ?? '—' }}"
                        class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600"
                        style="background:#f5f5f5;border-radius:12px;">
                </div>

                <!-- Admissão -->
                <div style="grid-column: span 3;">
                    <label class="block font-medium text-sm text-gray-700">Data de admissão</label>
                    <input type="text" readonly
                        value="{{ optional($user?->admissao)->format('d/m/Y') ?? '—' }}"
                        class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600"
                        style="background:#f5f5f5;border-radius:12px;">
                </div>
            </div>

            <!-- Linha informativa -->
            <div style="display:flex;align-items:center;justify-content:space-between;margin-top:20px;">
                <p style="font-size:12px;color:#6b7280;">Dados carregados de seu usuário.</p>
                @if(session('status'))
                    <span style="font-size:12px;color:#0f7c1c;">{{ session('status') }}</span>
                @endif
            </div>
        </div>

    </section>

<!-- Ionicons e script de toggle do sidebar -->
<script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
<script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
<script>
    (function() {
        const sidebar = document.getElementById('sidebar');
        const showBtn = document.getElementById('showSidebarBtn');
        const hideBtn = document.getElementById('hideSidebarBtn');

        function openSidebar() {
            if (window.innerWidth <= 768) {
                sidebar.style.display = 'block';
                showBtn.style.display = 'none';
                hideBtn.style.display = 'inline-block';
                document.body.style.overflow = 'hidden';
            }
        }
        function closeSidebar() {
            if (window.innerWidth <= 768) {
                sidebar.style.display = 'none';
                showBtn.style.display = 'inline-block';
                hideBtn.style.display = 'none';
                document.body.style.overflow = '';
            }
        }

        showBtn?.addEventListener('click', openSidebar);
        hideBtn?.addEventListener('click', closeSidebar);

        // Fecha sidebar ao clicar fora (mobile)
        document.addEventListener('click', (e) => {
            if (window.innerWidth > 768) return;
            if (!sidebar.contains(e.target) && !showBtn.contains(e.target) && !hideBtn.contains(e.target)) {
                closeSidebar();
            }
        });

        // Ajusta ao redimensionar
        window.addEventListener('resize', () => {
            if (window.innerWidth > 768) {
                sidebar.style.display = 'block';
                showBtn.style.display = 'inline-block';
                hideBtn.style.display = 'none';
                document.body.style.overflow = '';
            } else {
                sidebar.style.display = 'none';
            }
        });
    })();
</script>
@endsection
