@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

<div id="modulo4">

    <h2 class="titleItems mb-3">ARPT - Análise de Risco e Permissão de Trabalho</h2>

    @if(session('success'))
    <div class="alert alert-success text-center" role="alert">
        {{ session('success') }}
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger text-center" role="alert">
        {{ session('error') }}
    </div>
    @endif

    {{-- Vídeo --}}
    <div class="row">
        <div class="col-sm-12 col-md-8 m-l-r-auto">
            <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-soft">
                <iframe
                    src="https://player.vimeo.com/video/1110186074?h=820129b6aa&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
                    allow="autoplay; fullscreen; picture-in-picture; clipboard-write"
                    title="01_REGRA_PTLIBRAS"></iframe>
            </div>
            <script src="https://player.vimeo.com/api/player.js"></script>
        </div>
    </div>

    {{-- Texto alternativo do vídeo (mantido) --}}
    {{-- TEXTO ALTERNATIVO (DISCLOSURE) --}}
    <div class="row m-b-55 m-t-30">
        <details class="ss-disclosure">
            <summary>
                <span class="label">Clique e veja o texto alternativo do vídeo.</span>
                <span class="chev" aria-hidden="true"></span>
            </summary>

<div class="ss-disclosure-body">
  <p>O trabalho mais seguro é sempre o trabalho mais bem planejado. Para garantir que cada detalhe seja visto em atividades de alto risco ou não rotineiras, nós usamos uma ferramenta essencial: a <strong>ARPT — Análise de Risco e Permissão de Trabalho</strong>.</p>

  <p>A <strong>Análise de Risco</strong> é o nosso momento de pausa para pensar <strong>antes</strong> de agir. Em equipe, listamos cada passo da tarefa e nos perguntamos: <em>“O que pode dar errado aqui?”</em> Para cada risco encontrado, definimos uma <strong>barreira de proteção</strong>.</p>

  <p>A <strong>Permissão de Trabalho (PT)</strong> é a chave final. Ela confirma que a análise foi feita e que todas as medidas de segurança estão prontas para serem aplicadas. Não é apenas um papel — é o nosso <strong>passaporte para um trabalho seguro</strong>.</p>

  <p><strong>Nenhum trabalho de risco começa</strong> sem uma ARPT aprovada e compreendida por todos. Ela é a prova do nosso compromisso de que a tarefa será executada do início ao fim da maneira mais segura possível.</p>

  <p><strong>Lembre-se:</strong> gastar alguns minutos planejando a segurança garante que o trabalho termine bem. <strong>Pense antes, aja com segurança.</strong> Cuide de você e da sua equipe. <em>Até a próxima!</em></p>
</div>
        </details>
    </div>

    {{-- ESTILOS do ACORDIÃO --}}
    <style>
        /* Disclosure (substitui o acordeão) */
        .ss-disclosure {
            position: relative;
            /* evita sobreposição do vídeo */
            z-index: 2;
            border-radius: 16px;
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .08);
            overflow: clip;
        }

        .ss-disclosure[open] {
            box-shadow: 0 14px 32px rgba(0, 0, 0, .12);
        }

        .ss-disclosure>summary {
            list-style: none;
            /* remove marcador do summary */
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            cursor: pointer;
            padding: 14px 18px;
            font-weight: 800;
            letter-spacing: .2px;
            color: #1f2430;
            background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
            border-radius: 16px;
            outline: none;
            user-select: none;
        }

        .ss-disclosure>summary::-webkit-details-marker {
            display: none;
        }

        .ss-disclosure .chev::before {
            content: "▾";
            display: inline-block;
            transform: rotate(-90deg);
            transition: transform .2s ease;
            font-size: 14px;
            color: #07509D;
        }

        /* Estado aberto */
        .ss-disclosure[open]>summary {
            color: #07509D;
            background: linear-gradient(180deg, #f3f8ff 0%, #eef5ff 100%);
            border-bottom: 1px solid rgba(7, 80, 157, .12);
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .ss-disclosure[open] .chev::before {
            transform: rotate(0deg);
        }

        .ss-disclosure-body {
            padding: 16px 18px 18px;
            line-height: 1.6;
            color: #2b2f3a;
            background: #fff;
            border-bottom-left-radius: 16px;
            border-bottom-right-radius: 16px;
        }

        .ss-disclosure-body p {
            margin: 0 0 10px;
        }

        .ss-disclosure-body p:last-child {
            margin-bottom: 0;
        }
    </style>
    {{-- Texto do módulo (mantido) --}}
    <div class="ss-arpt mt-4">

        <!-- Intro -->
        <div class="ss-intro">
            A <strong>ARPT</strong> é a principal ferramenta de planejamento de segurança para tarefas de alto risco ou não rotineiras, onde o improviso é proibido.
        </div>

        <!-- Título do processo -->
        <h5 class="ss-section-title">
            <span class="ss-dot"></span>
            Processo em 2 passos
        </h5>

        <!-- Passos (grid) -->
        <div class="ss-grid">
            <!-- Passo 1 -->
            <div class="ss-card ss-step-1">
                <div class="ss-card-head">
                    <div class="ss-icon"><i class="fa fa-clipboard-list"></i></div>
                    <div>
                        <div class="ss-badge">Passo 1</div>
                        <h6 class="ss-card-title">Análise de Risco</h6>
                    </div>
                </div>
                <div class="ss-card-body">
                    <p class="mb-2">
                        Reunião da equipe para planejar antes de agir, respondendo 3 perguntas essenciais:
                    </p>
                    <ol class="ss-list-numbered">
                        <li><strong>O que vamos fazer?</strong> <span class="muted">(descrição detalhada da tarefa)</span></li>
                        <li><strong>O que pode dar errado?</strong> <span class="muted">(identificação de perigos e riscos)</span></li>
                        <li><strong>Como vamos impedir?</strong> <span class="muted">(definição de barreiras de proteção)</span></li>
                    </ol>
                    <div class="ss-note">
                        <i class="fa fa-users me-2"></i>
                        Esta conversa em equipe é fundamental: várias pessoas identificam mais riscos que uma só. Tudo é registrado no formulário da ARPT.
                    </div>
                </div>
            </div>

            <!-- Passo 2 -->
            <div class="ss-card ss-step-2">
                <div class="ss-card-head">
                    <div class="ss-icon"><i class="fa fa-clipboard-check"></i></div>
                    <div>
                        <div class="ss-badge">Passo 2</div>
                        <h6 class="ss-card-title">Permissão de Trabalho (PT)</h6>
                    </div>
                </div>
                <div class="ss-card-body">
                    <p class="mb-2">
                        Funciona como um checklist de piloto antes da decolagem. O líder verifica se o planejado na Análise de Risco está implementado:
                    </p>
                    <ul class="ss-list-check">
                        <li>Ferramentas corretas <span class="check">✓</span></li>
                        <li>EPIs adequados <span class="check">✓</span></li>
                        <li>Área isolada <span class="check">✓</span></li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Regras importantes -->
        <div class="ss-rules">
            <div class="ss-rules-head">
                <i class="fa fa-triangle-exclamation"></i>
                <strong>Regras importantes</strong>
            </div>
            <ul class="ss-rules-list">
                <li>O trabalho só inicia após verificação completa e <strong>assinatura da PT</strong>.</li>
                <li>Se algo mudar durante a tarefa, é preciso <strong>PARAR</strong> e reavaliar.</li>
                <li>Pode ser necessário <strong>refazer a ARPT</strong> se houver mudanças significativas.</li>
            </ul>
        </div>

        <!-- Princípio -->
        <div class="ss-highlight">
            <div class="ss-highlight-icon"><i class="fa fa-flag-checkered"></i></div>
            <div class="ss-highlight-text">
                <strong>Princípio fundamental:</strong> Planejar não é perder tempo — é garantir o futuro seguro da equipe.
            </div>
        </div>

    </div>

    <style>
        /* ====== ARPT (estilo local, sem conflitar com seu CSS global) ====== */
        .ss-arpt {
            --c-text: #1f2430;
            --c-soft: #f7f8fb;
            --c-line: rgba(0, 0, 0, .08);
        }

        .ss-arpt .ss-intro {
            color: var(--c-text);
            background: #fff;
            border: 1px solid var(--c-line);
            padding: 12px 14px;
            border-radius: 12px;
            box-shadow: 0 6px 16px rgba(0, 0, 0, .06);
            margin-bottom: 14px;
        }

        /* Título de seção */
        .ss-arpt .ss-section-title {
            font-weight: 800;
            color: #07509D;
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 10px 0 12px;
        }

        .ss-arpt .ss-dot {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            background: #07509D;
            display: inline-block;
        }

        /* Grid de passos */
        .ss-arpt .ss-grid {
            display: grid;
            gap: 16px;
            grid-template-columns: 1fr;
        }

        @media (min-width:768px) {
            .ss-arpt .ss-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        /* Cards */
        .ss-arpt .ss-card {
            background: #fff;
            border: 1px solid var(--c-line);
            border-radius: 14px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, .06);
            overflow: hidden;
            transition: transform .15s ease, box-shadow .15s ease;
        }

        .ss-arpt .ss-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 12px 26px rgba(0, 0, 0, .12);
        }

        .ss-arpt .ss-card-head {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 14px;
            border-bottom: 1px solid var(--c-line);
            background: linear-gradient(180deg, #fff, #fafbff);
        }

        .ss-arpt .ss-icon {
            flex: 0 0 42px;
            width: 42px;
            height: 42px;
            border-radius: 12px;
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 18px;
        }

        .ss-arpt .ss-step-1 .ss-icon {
            background: #243782;
        }

        .ss-arpt .ss-step-2 .ss-icon {
            background: #43aaa0;
        }

        .ss-arpt .ss-badge {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 999px;
            font-size: 11px;
            font-weight: 800;
            letter-spacing: .2px;
            color: #243782;
            background: #e8ecff;
        }

        .ss-arpt .ss-card-title {
            margin: 4px 0 0;
            font-weight: 800;
            color: var(--c-text);
        }

        .ss-arpt .ss-card-body {
            padding: 14px;
            color: var(--c-text);
        }

        /* Listas */
        .ss-arpt .ss-list-numbered {
            margin: .5rem 0 0 1.2rem;
        }

        .ss-arpt .ss-list-numbered li {
            margin-bottom: .35rem;
        }

        .ss-arpt .muted {
            color: #5b626e;
            font-weight: 500;
        }

        .ss-arpt .ss-list-check {
            margin: .5rem 0 0;
            padding: 0;
            list-style: none;
        }

        .ss-arpt .ss-list-check li {
            position: relative;
            margin: 0 0 .35rem 0;
            padding-left: .75rem;
        }

        .ss-arpt .ss-list-check .check {
            font-weight: 900;
            margin-left: .35rem;
            color: #2ea043;
        }

        /* Observação (nota) */
        .ss-arpt .ss-note {
            margin-top: .7rem;
            padding: 10px 12px;
            border-radius: 12px;
            background: #fff7e6;
            color: #7a4a00;
            border: 1px solid #ffd48a;
            font-size: 14px;
        }

        /* Regras importantes */
        .ss-arpt .ss-rules {
            margin-top: 14px;
            background: #fff;
            border: 1px solid var(--c-line);
            border-radius: 12px;
            box-shadow: 0 6px 16px rgba(0, 0, 0, .06);
        }

        .ss-arpt .ss-rules-head {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 12px 14px;
            border-bottom: 1px solid var(--c-line);
            color: #a14a00;
            background: #fff7e6;
        }

        .ss-arpt .ss-rules-list {
            margin: 0;
            padding: 12px 18px 14px 32px;
            color: var(--c-text);
        }

        .ss-arpt .ss-rules-list li {
            margin-bottom: .35rem;
        }

        /* Destaque final */
        .ss-arpt .ss-highlight {
            margin-top: 14px;
            display: flex;
            gap: 12px;
            align-items: flex-start;
            background: linear-gradient(180deg, #fff, #f9fbff);
            border: 1px solid rgba(7, 80, 157, .15);
            border-left: 4px solid #07509D;
            border-radius: 12px;
            padding: 12px 14px;
            color: var(--c-text);
        }

        .ss-arpt .ss-highlight-icon {
            flex: 0 0 40px;
            width: 40px;
            height: 40px;
            display: grid;
            place-items: center;
            background: #243782;
            color: #fff;
            border-radius: 12px;
            font-size: 18px;
        }

        .ss-arpt .ss-highlight-text {
            line-height: 1.45;
        }
    </style>

    {{-- Ação --}}
    <div class="row">
        <div class="col-sm-12 text-center mt-2">
            @if (Auth::user()->usu_resp_mod4 == 1)
            <div class="d-flex justify-content-center align-items-center">
                <div class="card mb-4 bodyModulo4" style="max-width:540px;">
                    <div class="card-body">
                        <h5 class="card-title text-white">Parabéns!!!</h5>
                        <p class="card-text text-white">.</p>
                        <p class="card-text"><small class="text-white">Mas ainda não acabou, continue utilizando o game para pontuar</small></p>
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-center">
                <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            </div>
            @else
            <button class="btn btn-success btn-xl btn-cta" onclick="openGameModal()">
                <i class="fa fa-play me-2"></i> Iniciar Atividade
            </button>
            <br><br>
            <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar a Trilha do Conhecimento</a>
            @endif
        </div>
    </div>

</div>

{{-- ===================== MODAL DO JOGO ===================== --}}
<div class="modal fade" id="modalQuestao3" tabindex="-1" role="dialog" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-fullscreen" role="document">
        <div class="modal-content game-modal bodyBlue">

            <div class="modal-header border-0 flex-column text-center text-white pt-4">
                <div class="d-flex align-items-center justify-content-center gap-2 flex-wrap mb-2">
                    <span class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-font me-1"></i> ANAGRAMA DE PALAVRAS
                    </span>
                    <span id="pontuacao" class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        QUESTÃO 1 - ANAGRAMA DE PALAVRAS
                    </span>
                    <span id="tempoLabel" class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-clock me-1"></i> 0s
                    </span>
                    <span id="progressoLabel" class="badge bg-dark bg-opacity-25 px-3 py-2 rounded-pill">
                        <i class="fa fa-check-double me-1"></i> 0/3
                    </span>
                </div>

                <p class="m-0 small text-white-50">
                    De acordo com o texto deste módulo, as letras a seguir formam uma palavra chave. Digite a palavra abaixo:
                </p>

                <p id="dicas" class="mt-2 mb-0"></p>

                <button type="button" class="btn btn-warning btn-sm mt-3 btn-pill" onclick="closeGameModal()">
                    Responder Depois
                </button>

                <div id="resultado" class="w-100 mt-3 fw-bold" style="min-height:24px;" aria-live="polite"></div>
            </div>

            <div class="px-3 pb-5">
                <div class="container-xxl">
                    <div class="d-flex justify-content-center">
                        <div id="letras" class="letters-wrap"></div>
                    </div>

                    <div class="d-flex justify-content-center mt-3">
                        <input type="text" id="resposta" class="form-control answer-input"
                            placeholder="Digite sua resposta" autocomplete="off" />
                    </div>

                    <div class="d-flex justify-content-center gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-pill btn-cta" id="btnVerificar">
                            Verificar
                        </button>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

{{-- ===================== ESTILOS ===================== --}}
<style>
    :root {
        --brand: #1B5F77;
        --accent: #ECA935;
        --glass-bg: rgba(255, 255, 255, .08);
        --glass-stroke: rgba(255, 255, 255, .15);
    }

    .shadow-soft {
        box-shadow: 0 10px 30px rgba(0, 0, 0, .12);
    }

    .glass {
        backdrop-filter: blur(8px);
        background: var(--glass-bg);
        border: 1px solid var(--glass-stroke);
    }

    .btn-pill {
        border-radius: 999px;
    }

    .btn-xl {
        padding: 14px 28px;
        border-radius: 16px;
        font-weight: 700;
        letter-spacing: .5px;
    }

    .btn-cta {
        box-shadow: 0 10px 20px rgba(16, 185, 129, .25);
        transform: translateZ(0);
        transition: .2s ease;
    }

    .btn-cta:hover {
        transform: translateY(-2px);
    }

    .soft-card {
        border-radius: 16px;
        overflow: hidden;
        background: #fff;
        border: 0;
        box-shadow: 0 10px 30px rgba(0, 0, 0, .06);
    }

    .gradientModern {
        background: radial-gradient(1200px 600px at 20% 0%, #0ea5b0 0%, rgba(14, 165, 176, .15) 35%, transparent 60%),
            linear-gradient(180deg, #0b2e3a 0%, #09252e 100%);
    }

    .game-modal {
        min-height: 100%;
    }

    /* Letras */
    .letters-wrap {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        justify-content: center;
        max-width: 900px;
    }

    .letters-wrap .letter-chip {
        background: #43AAA0;
        color: #fff;
        border-radius: 10px;
        padding: 12px 16px;
        font-size: 22px;
        font-weight: 800;
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 44px;
        user-select: none;
        transition: transform .15s ease, box-shadow .15s ease;
        box-shadow: 0 6px 16px rgba(0, 0, 0, .10);
        text-transform: uppercase;
    }

    .letters-wrap .letter-chip:hover {
        transform: translateY(-2px);
    }

    .answer-input {
        max-width: 420px;
        text-transform: uppercase;
        text-align: center;
        padding: 14px 18px;
        font-weight: 800;
        letter-spacing: 1px;
        border-radius: 14px;
        border: 1px solid rgba(0, 0, 0, .1);
        box-shadow: 0 6px 16px rgba(0, 0, 0, .06);
    }

    @media (max-width: 576px) {
        .letters-wrap .letter-chip {
            font-size: 18px;
            padding: 10px 12px;
        }
    }
</style>

{{-- ===================== SCRIPT ===================== --}}
<script>
    // ===== Rotas/Segurança =====
    const ROUTE_POST = @json(route('modulos.jogo.store', ['modulo' => 4]));
    const CSRF_TOKEN = @json(csrf_token());

    // Modal
    function openGameModal() {
        const modal = new bootstrap.Modal(document.getElementById('modalQuestao3'));
        modal.show();
    }

    function closeGameModal() {
        const el = document.getElementById('modalQuestao3');
        const modal = bootstrap.Modal.getOrCreateInstance(el);
        modal.hide();
    }
    window.openGameModal = openGameModal;
    window.closeGameModal = closeGameModal;

    // ======= LÓGICA DO JOGO =======
    let dicaAtual;
    const palavras = ["TRABALHO", "COMPLETA", "PARAR"];
    const dicas = [
        "A ARPT é um processo em duas etapas — Análise de Risco e Permissão de ________ — usado para planejar tarefas de alto risco ou não rotineiras.",
        "O trabalho só pode começar após a verificação ________ e assinatura da Permissão de Trabalho.",
        "Se houver mudanças durante a execução, é obrigatório _____ e reavaliar antes de prosseguir."
    ];

    let palavraOriginal;
    let letrasEmbaralhadas;
    let pontuacao = 0;
    const totalPalavras = palavras.length;
    let timer = null;
    let segundos = 0;
    let timerStarted = false;
    let envioEfetuado = false;

    function embaralhar(palavra) {
        return palavra.split('').sort(() => Math.random() - 0.5).join('');
    }

    function exibirLetras(letras) {
        const container = document.getElementById("letras");
        container.innerHTML = '';
        letras.split('').forEach(letra => {
            const span = document.createElement('span');
            span.className = 'letter-chip';
            span.innerText = letra;
            container.appendChild(span);
        });
    }

    function updateTempoLabel() {
        const el = document.getElementById('tempoLabel');
        if (el) el.innerHTML = `<i class="fa fa-clock me-1"></i> ${segundos}s`;
    }

    function updateProgresso() {
        const pr = document.getElementById('progressoLabel');
        if (pr) pr.innerHTML = `<i class="fa fa-check-double me-1"></i> ${pontuacao}/${totalPalavras}`;
    }

    function enviarConclusao() {
        if (envioEfetuado) return;
        envioEfetuado = true;

        closeGameModal();

        const form = document.createElement('form');
        form.method = 'POST';
        form.action = ROUTE_POST;
        form.style.display = 'none';

        form.innerHTML = `
      <input type="hidden" name="_token" value="${CSRF_TOKEN}">
      <input type="hidden" name="concluido" value="1">
      <input type="hidden" name="tempo" value="${segundos}">
      <input type="hidden" name="acertos" value="${totalPalavras}">
      <input type="hidden" name="total" value="${totalPalavras}">
    `;
        document.body.appendChild(form);
        if (form.requestSubmit) form.requestSubmit();
        else form.submit();
    }

    function iniciarNovaPalavra() {
        if (pontuacao >= totalPalavras) {
            pararTimer();
            document.getElementById("resultado").innerText =
                `Parabéns! Você respondeu todas as palavras em ${segundos} segundos!`;
            document.getElementById("btnVerificar").disabled = true;
            document.getElementById("resposta").disabled = true;
            enviarConclusao();
            return;
        }

        palavraOriginal = palavras[pontuacao];
        letrasEmbaralhadas = embaralhar(palavraOriginal);
        exibirLetras(letrasEmbaralhadas);

        dicaAtual = dicas[pontuacao];
        document.getElementById("dicas").innerText = dicaAtual;

        const input = document.getElementById("resposta");
        input.value = "";
        input.focus();
        document.getElementById("resultado").innerText = "";
        document.getElementById("pontuacao").innerText =
            `QUESTÃO ${pontuacao + 1} - ANAGRAMA DE PALAVRAS`;

        updateProgresso();
    }

    function iniciarTimer() {
        if (!timerStarted) {
            timerStarted = true;
            timer = setInterval(() => {
                segundos++;
                updateTempoLabel();
            }, 1000);
        }
    }

    function pararTimer() {
        if (timer) {
            clearInterval(timer);
            timer = null;
        }
    }

    function verificarResposta() {
        const resposta = document.getElementById("resposta").value.toUpperCase();
        if (resposta === palavraOriginal) {
            pontuacao++;
            document.getElementById("resultado").innerText = "Parabéns! Você acertou!";
            iniciarNovaPalavra();
        } else {
            document.getElementById("resultado").innerText = "Essa palavra não é válida. Tente novamente!";
        }
        document.getElementById("pontuacao").innerText =
            `QUESTÃO ${pontuacao + 1} - ANAGRAMA DE PALAVRAS`;
        updateProgresso();
    }

    function upWord(palavra) {
        document.getElementById("resposta").value = palavra.toUpperCase();
    }

    // Eventos
    document.addEventListener('DOMContentLoaded', () => {
        const input = document.getElementById("resposta");
        input.addEventListener("keypress", (event) => {
            if (event.key === "Enter") {
                event.preventDefault();
                verificarResposta();
            }
        });
        input.addEventListener("input", () => {
            upWord(input.value);
            iniciarTimer();
        });

        document.getElementById("btnVerificar").addEventListener("click", verificarResposta);

        // Reinicia estado do jogo sempre que o modal abrir
        const jogoModalEl = document.getElementById('modalQuestao3');
        jogoModalEl.addEventListener('show.bs.modal', () => {
            pontuacao = 0;
            segundos = 0;
            timerStarted = false;
            envioEfetuado = false;
            updateTempoLabel();
            updateProgresso();
            document.getElementById("btnVerificar").disabled = false;
            document.getElementById("resposta").disabled = false;
            iniciarNovaPalavra();
        });

        // Para o timer ao fechar
        jogoModalEl.addEventListener('hide.bs.modal', () => {
            pararTimer();
        });
    });

    // Expor funções usadas no HTML (se precisar)
    window.verificarResposta = verificarResposta;
    window.upWord = upWord;
</script>

@endsection