@extends('layouts.main')

@section('title', 'SafetyStart - Modulos')

@section('content')

<div id="modulo1">

    <h2 class="titleItems mb-3">Perigo x Risco - A Base da Percepção</h2>

    @if(session('success'))
    <div class="alert alert-success text-center" role="alert">
        {{ session('success') }}
    </div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger text-center" role="alert">
        {{ session('error') }}
    </div>
    @endif

    {{-- VÍDEO --}}
    <div class="row">
        <div class="col-sm-12 col-md-8 m-l-r-auto">
            <div class="ratio ratio-16x9 rounded-4 overflow-hidden shadow-soft">
                <iframe
                    src="https://player.vimeo.com/video/1110185659?h=69942ecfd6&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"
                    allow="autoplay; fullscreen; picture-in-picture; clipboard-write"
                    title="01_REGRA_PTLIBRAS"></iframe>
            </div>
            <script src="https://player.vimeo.com/api/player.js"></script>
        </div>
    </div>

    {{-- TEXTO ALTERNATIVO (DISCLOSURE) --}}
    <div class="row m-b-55 m-t-30">
        <details class="ss-disclosure">
            <summary>
                <span class="label">Clique e veja o texto alternativo do vídeo.</span>
                <span class="chev" aria-hidden="true"></span>
            </summary>

            <div class="ss-disclosure-body">
                <p>Em nosso dia a dia, estamos cercados de informações. Mas a segurança não está apenas no que vemos, e sim na nossa capacidade de perceber. E esse é o segredo da segurança.</p>
                <p>Primeiro, vamos entender o que é o <strong>PERIGO</strong>. Pense assim: o perigo é qualquer situação ou coisa que pode machucar. A mancha de óleo no chão, uma ferramenta fora do lugar... o perigo está ali, parado.</p>
                <p>E o <strong>RISCO</strong>? O risco aparece quando a gente se aproxima ou interage com o perigo. É a chance do acidente acontecer.</p>
                <p><strong>É aqui que você faz a diferença.</strong> Ter Percepção de Risco é a sua habilidade de enxergar o perigo, entender a chance do acidente e, o principal: agir para evitar que ele aconteça.</p>
                <p><em>Treine seu olhar. Questione seu caminho. A sua segurança começa na sua percepção.</em></p>
            </div>
        </details>
    </div>

    {{-- ESTILOS do DISCLOSURE --}}
    <style>
        .ss-disclosure {
            position: relative;
            z-index: 2;
            border-radius: 16px;
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            box-shadow: 0 10px 26px rgba(0, 0, 0, .08);
            overflow: clip;
        }

        .ss-disclosure[open] {
            box-shadow: 0 14px 32px rgba(0, 0, 0, .12);
        }

        .ss-disclosure>summary {
            list-style: none;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            cursor: pointer;
            padding: 14px 18px;
            font-weight: 800;
            letter-spacing: .2px;
            color: #1f2430;
            background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
            border-radius: 16px;
            user-select: none;
        }

        .ss-disclosure>summary::-webkit-details-marker {
            display: none;
        }

        .ss-disclosure .chev::before {
            content: "▾";
            display: inline-block;
            transform: rotate(-90deg);
            transition: .2s;
            font-size: 14px;
            color: #07509D;
        }

        .ss-disclosure[open]>summary {
            color: #07509D;
            background: linear-gradient(180deg, #f3f8ff 0%, #eef5ff 100%);
            border-bottom: 1px solid rgba(7, 80, 157, .12);
            border-bottom-left-radius: 0;
            border-bottom-right-radius: 0;
        }

        .ss-disclosure[open] .chev::before {
            transform: rotate(0deg);
        }

        .ss-disclosure-body {
            padding: 16px 18px 18px;
            line-height: 1.6;
            color: #2b2f3a;
            background: #fff;
            border-bottom-left-radius: 16px;
            border-bottom-right-radius: 16px;
        }

        .ss-disclosure-body p {
            margin: 0 0 10px;
        }

        .ss-disclosure-body p:last-child {
            margin-bottom: 0;
        }
    </style>

    {{-- ===== Texto do módulo ===== --}}
    <div class="ss-module mt-4">

        <div class="ss-section">
            <p class="ss-intro">
                Bem-vindo ao nosso <strong>primeiro módulo</strong> de aprendizado!
            </p>
            <p class="ss-intro">
                Vamos começar com o passo mais importante para a sua segurança: entender a diferença entre
                <strong>Perigo</strong> e <strong>Risco</strong>.
            </p>
            <p class="ss-intro">
                Muitas vezes usamos essas palavras como sinônimos, mas na segurança do trabalho, elas têm significados muito diferentes.
                Entender essa diferença é o que ativa a sua <strong>Percepção de Risco</strong>.
            </p>
        </div>

        <div class="row g-3">
            <div class="col-12 col-lg-6">
                <div class="ss-card">
                    <div class="ss-card-header">
                        <span class="ss-chip danger"><i class="fa fa-exclamation-triangle me-1"></i> PERIGO</span>
                    </div>
                    <div class="ss-card-body">
                        <p class="mb-2">
                            <span class="ss-key">A fonte do problema</span> — uma condição do ambiente que pode causar danos.
                        </p>
                        <div class="ss-examples">
                            <span class="ss-ex-title">Exemplos:</span>
                            <ul class="mb-0">
                                <li>Buraco na calçada</li>
                                <li>Poça de óleo no chão</li>
                                <li>Lâmina de máquina</li>
                                <li>Produto químico</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div><!-- col -->

            <div class="col-12 col-lg-6">
                <div class="ss-card">
                    <div class="ss-card-header">
                        <span class="ss-chip risk"><i class="fa fa-random me-1"></i> RISCO</span>
                    </div>
                    <div class="ss-card-body">
                        <p class="mb-2">
                            <span class="ss-key">A chance do problema acontecer</span> — a probabilidade do perigo causar dano real, considerando
                            <em>exposição</em> e <em>gravidade</em>.
                        </p>
                        <div class="ss-examples">
                            <span class="ss-ex-title">Exemplos:</span>
                            <ul class="mb-0">
                                <li>Chance de cair no buraco</li>
                                <li>Risco de escorregar na poça</li>
                                <li>Risco de amputação na máquina sem proteção</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div><!-- col -->
        </div><!-- row -->

        <div class="ss-formula my-3">
            <div class="ss-formula-chip"><i class="fa fa-calculator me-2"></i>Fórmula simples</div>
            <div class="ss-formula-grid">
                <div><span class="ss-badge danger">PERIGO</span> = A FONTE DO PROBLEMA</div>
                <div><span class="ss-badge risk">RISCO</span> = A CHANCE DO PROBLEMA ACONTECER</div>
            </div>
        </div>

        <div class="row g-3 align-items-stretch">
            <div class="col-12 col-xl-6">
                <div class="ss-panel">
                    <div class="ss-panel-title"><i class="fa fa-eye me-2"></i>PERCEPÇÃO DE RISCO</div>
                    <ul class="ss-list mb-0">
                        <li>Ver o Perigo</li>
                        <li>Entender o Risco</li>
                        <li>Agir com Segurança</li>
                    </ul>
                </div>
            </div>
            <div class="col-12 col-xl-6">
                <div class="ss-panel">
                    <div class="ss-panel-title"><i class="fa fa-clipboard-check me-2"></i>Processo prático para cada tarefa</div>
                    <ol class="ss-list numbered mb-0">
                        <li><strong>PERIGO:</strong> O que pode me machucar?</li>
                        <li><strong>RISCO:</strong> Qual a chance de me machucar e a gravidade?</li>
                        <li><strong>AÇÃO SEGURA:</strong> O que faço para evitar?</li>
                    </ol>
                </div>
            </div>
        </div>

        <div class="ss-highlight mt-3">
            <div class="ss-highlight-icon"><i class="fa fa-brain"></i></div>
            <div class="ss-highlight-text">
                <div class="fw-bold">Mensagem central</div>
                Transformar essa análise consciente (<em>Ver → Entender → Agir</em>) em hábito diário é a base de toda segurança no trabalho.
                <br>
                Em cada tarefa, pergunte-se: <em>Onde está o perigo?</em> <em>Qual é o risco?</em>
            </div>
        </div>

    </div>

    {{-- ESTILOS do BLOCO DO MÓDULO --}}
    <style>
        .ss-module {
            --ss-bg: #ffffff;
            --ss-accent: #07509D;
            --ss-soft: #f7f8fb;
            --ss-text: #2a2a2a;
        }

        .ss-module .ss-intro {
            color: var(--ss-text);
            margin-bottom: .6rem;
        }

        .ss-card {
            background: var(--ss-bg);
            border: 1px solid rgba(0, 0, 0, .06);
            border-radius: 14px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, .05);
            overflow: hidden;
            height: 100%;
        }

        .ss-card-header {
            padding: 10px 14px;
            border-bottom: 1px solid rgba(0, 0, 0, .06);
            background: linear-gradient(180deg, #fff, #fafbff);
        }

        .ss-card-body {
            padding: 14px;
            font-size: 15px;
            color: var(--ss-text);
        }

        .ss-key {
            font-weight: 800;
            color: #1b273a;
        }

        .ss-chip {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-weight: 800;
            font-size: 12px;
            letter-spacing: .2px;
            padding: 6px 10px;
            border-radius: 999px;
            color: #fff;
        }

        .ss-chip.danger {
            background: #d62828;
        }

        .ss-chip.risk {
            background: #0f7c1c;
        }

        .ss-examples {
            margin-top: .5rem;
        }

        .ss-examples ul {
            padding-left: 1.1rem;
        }

        .ss-ex-title {
            display: block;
            font-size: .875rem;
            color: #5a6372;
            margin-bottom: .25rem;
        }

        .ss-formula {
            background: var(--ss-soft);
            border: 1px dashed rgba(7, 80, 157, .3);
            border-radius: 12px;
            padding: 10px 12px;
        }

        .ss-formula-chip {
            font-weight: 800;
            font-size: 12px;
            color: #0b3b77;
            background: #e8f1ff;
            border: 1px solid #cce1ff;
            display: inline-flex;
            align-items: center;
            padding: 6px 10px;
            border-radius: 999px;
            margin-bottom: 8px;
        }

        .ss-formula-grid {
            display: grid;
            gap: 8px;
            grid-template-columns: 1fr;
        }

        @media (min-width:768px) {
            .ss-formula-grid {
                grid-template-columns: 1fr 1fr;
            }
        }

        .ss-badge {
            display: inline-block;
            font-weight: 900;
            color: #fff;
            padding: 4px 8px;
            border-radius: 8px;
            font-size: 12px;
            margin-right: 6px;
        }

        .ss-badge.danger {
            background: #d62828;
        }

        .ss-badge.risk {
            background: #0f7c1c;
        }

        .ss-panel {
            height: 100%;
            background: #fff;
            border: 1px solid rgba(0, 0, 0, .06);
            border-radius: 14px;
            padding: 14px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, .05);
        }

        .ss-panel-title {
            font-weight: 900;
            color: #243782;
            margin-bottom: 8px;
            letter-spacing: .2px;
        }

        .ss-list {
            color: #2c2c2c;
        }

        .ss-list li {
            margin-bottom: 6px;
        }

        .ss-list.numbered {
            padding-left: 1.2rem;
        }

        .ss-highlight {
            display: flex;
            gap: 12px;
            align-items: flex-start;
            background: linear-gradient(180deg, #fff, #f9fbff);
            border: 1px solid rgba(7, 80, 157, .15);
            border-left: 4px solid var(--ss-accent);
            border-radius: 12px;
            padding: 12px 14px;
        }

        .ss-highlight-icon {
            flex: 0 0 38px;
            height: 38px;
            width: 38px;
            display: grid;
            place-items: center;
            background: #243782;
            color: #fff;
            border-radius: 10px;
            font-size: 18px;
        }

        .ss-highlight-text {
            color: #1f2430;
            font-size: 15px;
        }
    </style>
</div>

{{-- ===== Ação / Botões ===== --}}
<div class="row mt-2">
    <div class="col-sm-12 text-center mt-2">
        @if (Auth::user()->usu_resp_mod1 == 1)
        <div class="d-flex justify-content-center align-items-center">
            <div class="card mb-4 bodyModulo1" style="max-width:540px;">
                <div class="card-body">
                    <h5 class="card-title text-white">Parabéns!!!</h5>
                    <p class="card-text text-white">Você finalizou este módulo.</p>
                    <p class="card-text"><small class="text-white">Mas ainda não acabou, continue utilizando o game para pontuar</small></p>
                </div>
            </div>
        </div>
        <div class="d-flex justify-content-center">
            <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar à Trilha do Conhecimento</a>
        </div>
        @else
        <button class="btn btn-success btn-xl btn-cta" onclick="openGameModal()">
            <i class="fa fa-play me-2"></i> Iniciar Atividade
        </button>
        <br><br>
        <a class="btn btn-secondary btn-pill" style="background-color:#1B5F77;" href="/modulos">Voltar à Trilha do Conhecimento</a>
        @endif
    </div>
</div>

{{-- =================================================================== --}}
{{-- ===================== MODAL DO JOGO (VERSÃO MELHORADA) ===================== --}}
{{-- =================================================================== --}}
<div class="modal fade" id="gameModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-lg modal-fullscreen-lg-down modal-dialog-centered" role="document">
        <div class="modal-content game-modal">

            {{-- CABEÇALHO DO MODAL --}}
            <div class="modal-header">
                <div class="game-header-info">
                    <span class="badge">
                        <i class="fa fa-bolt me-1"></i> PERIGO OU RISCO
                    </span>
                    <span id="timerLabel" class="badge">
                        <i class="fa fa-clock me-1"></i> 0s
                    </span>
                </div>
                <div class="steps" aria-label="Progresso">
                    <div class="step-line">
                        <div class="step-line-progress" id="progress-bar"></div>
                    </div>
                    <span class="step-dot is-active" id="dot1">1</span>
                    <span class="step-dot" id="dot2">2</span>
                </div>
            </div>

            {{-- CORPO DO JOGO --}}
            <div class="modal-body">
                <form id="gameForm" method="POST" action="{{ route('modulos.jogo.store', ['modulo' => 1]) }}">
                    @csrf
                    <input type="hidden" id="inputAcertos" name="acertos" value="0">
                    <input type="hidden" id="inputTotal" name="total" value="2">
                    <input type="hidden" id="inputTempo" name="tempo" value="0">
                    <input type="hidden" id="inputConcluido" name="concluido" value="0">
                </form>

                <div class="game-container">
                    <p class="game-instruction">Analise a imagem e classifique a situação:</p>

                    <div id="game-stage" class="game-stage">
                        <figure class="picture-frame">
                            <img id="game-image" src="{{ asset('img/modulos/modulo1/1.jpg') }}" class="img-fluid" alt="Cena do jogo">
                        </figure>
                        <div id="game-choices" class="choices">
                            <button type="button" class="choice" data-answer="1">
                                PERIGO
                            </button>
                            <button type="button" class="choice" data-answer="2">
                                RISCO
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            {{-- RODAPÉ DO MODAL --}}
            <div class="modal-footer mt-3">
                <button type="button" class="btn btn-secondary btn-sm btn-pill" onclick="closeGameModal()">
                    Responder Depois
                </button>
            </div>

        </div>
    </div>
</div>

{{-- ===================== MODAL DE FEEDBACK (VERSÃO MELHORADA) ===================== --}}
<div class="modal fade" id="feedbackModal" tabindex="-1" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content feedback-modal-content">
            <div class="modal-body text-center">
                <div id="feedback-icon-container" class="mb-3">
                    {{-- O ícone será injetado aqui pelo JavaScript --}}
                </div>
                <h4 id="feedback-title" class="mb-2"></h4>
                <p id="feedback-text" class="m-0"></p>
                <button type="button" class="btn btn-primary btn-pill mt-4" onclick="closeFeedbackModal()">
                    Entendido, continuar
                </button>
            </div>
        </div>
    </div>
</div>

{{-- ===================== ESTILOS GERAIS DO JOGO (VERSÃO MELHORADA) ===================== --}}
<style>
    :root {
        --brand: #1B5F77;
        --success: #16a34a;
        --danger: #dc3545;
        --light: #f8f9fa;
        --dark: #212529;
        --bs-modal-bg: #07509D;
        /* Fundo do modal do jogo */
    }

    /* --- Botões da página principal --- */
    .btn-pill {
        border-radius: 999px;
    }

    .btn-xl {
        padding: 14px 28px;
        border-radius: 16px;
        font-weight: 700;
        letter-spacing: .5px;
    }

    .btn-cta {
        box-shadow: 0 10px 20px rgba(22, 163, 74, .25);
        transition: transform .2s ease-out;
    }

    .btn-cta:hover {
        transform: translateY(-3px);
    }

    /* --- Estilo Base do Modal do Jogo --- */
    .game-modal {
        background: linear-gradient(160deg, #1B5F77 0%, #07509D 100%);
        border: none;
        color: white;
        display: flex;
        flex-direction: column;
        height: 100%;
        /* Garante altura total no modo fullscreen */
    }

    .modal-dialog.modal-fullscreen-lg-down .modal-content {
        border-radius: 0;
    }

    @media (min-width: 992px) {
        .modal-dialog.modal-fullscreen-lg-down .modal-content {
            border-radius: 1.5rem;
            max-height: 90vh;
        }
    }

    .game-modal .modal-header,
    .game-modal .modal-footer {
        border: none;
        padding: 1rem 1.5rem;
    }

    /* --- Cabeçalho do Jogo --- */
    .modal-header {
        flex-direction: column;
        align-items: stretch;
        gap: .75rem;
    }

    .game-header-info {
        display: flex;
        justify-content: space-between;
        align-items: center;
        font-weight: 600;
        font-size: .875rem;
    }

    .game-header-info .badge {
        background-color: rgba(0, 0, 0, .2);
        padding: .5em 1em;
        border-radius: 999px;
    }

    .steps {
        position: relative;
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 100%;
        padding: 0 5px;
        /* Alinha os pontos com o fim da linha */
    }

    .step-line {
        position: absolute;
        height: 4px;
        background-color: rgba(255, 255, 255, .2);
        width: calc(100% - 10px);
        /* Desconta o padding */
        top: 50%;
        transform: translateY(-50%);
        border-radius: 4px;
        overflow: hidden;
    }

    .step-line-progress {
        width: 0%;
        height: 100%;
        background-color: #fff;
        transition: width .4s ease-in-out;
    }

    .step-dot {
        width: 24px;
        height: 24px;
        border-radius: 50%;
        background: rgba(255, 255, 255, .25);
        display: grid;
        place-items: center;
        color: rgba(255, 255, 255, .7);
        font-weight: 700;
        font-size: .8rem;
        z-index: 1;
        transition: all .3s ease;
        border: 2px solid transparent;
    }

    .step-dot.is-active {
        background: #fff;
        color: var(--brand);
        transform: scale(1.1);
        border-color: rgba(255, 255, 255, 0.5);
    }

    /* --- Corpo do Jogo --- */
    .modal-body {
        flex-grow: 1;
        /* Faz o corpo ocupar o espaço disponível */
        display: flex;
        flex-direction: column;
        justify-content: center;
        padding: 1rem 1.5rem;
    }

    .game-instruction {
        text-align: center;
        font-weight: 500;
        color: rgba(255, 255, 255, .8);
        margin-bottom: 1rem;
    }

    .game-stage {
        opacity: 1;
        transform: translateY(0);
        transition: opacity .4s ease-out, transform .4s ease-out;
    }

    .game-stage.is-loading {
        opacity: 0;
        transform: translateY(10px);
    }

    .picture-frame img {
        width: 100%;
        max-width: 560px;
        margin: 0 auto;
        display: block;
        border-radius: 1rem;
        border: 2px solid rgba(255, 255, 255, .15);
        box-shadow: 0 10px 30px rgba(0, 0, 0, .2);
    }

    .choices {
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        justify-content: center;
        margin-top: 1.5rem;
    }

    .choice {
        --bg: #fff;
        --color: #07509D;
        --shadow: rgba(0, 0, 0, .15);
        border: none;
        padding: 14px 24px;
        border-radius: 12px;
        font-weight: 800;
        letter-spacing: .6px;
        text-transform: uppercase;
        color: var(--color);
        background: var(--bg);
        box-shadow: 0 6px 16px var(--shadow);
        transition: all .2s;
        min-width: 150px;
        text-align: center;
    }

    .choice:hover:not(:disabled) {
        transform: translateY(-3px);
        box-shadow: 0 10px 22px var(--shadow);
    }

    .choice:disabled {
        opacity: .5;
        cursor: not-allowed;
    }

    .choice.correct:disabled {
        /* Estado de resposta correta */
        background-color: var(--success);
        color: #fff;
        opacity: 1;
    }

    .choice.incorrect:disabled {
        /* Estado de resposta errada (quando outra é a correta) */
        opacity: .3;
    }

    /* --- Rodapé do Jogo --- */
    .modal-footer {
        justify-content: center;
    }

    /* --- Estilo do Modal de Feedback --- */
    .feedback-modal-content {
        border-radius: 1.25rem;
        border: none;
        box-shadow: 0 15px 40px rgba(0, 0, 0, .15);
        padding: 1.5rem;
    }

    .feedback-icon {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        display: grid;
        place-items: center;
        font-size: 1.75rem;
        color: #fff;
        margin: 0 auto;
    }

    .feedback-icon.success {
        background-color: var(--success);
    }

    .feedback-icon.danger {
        background-color: var(--danger);
    }
</style>

{{-- ===================== SCRIPT (Jogo - VERSÃO MELHORADA) ===================== --}}
<script>
    document.addEventListener('DOMContentLoaded', () => {

        // --- Elementos do DOM ---
        const gameModalEl = document.getElementById('gameModal');
        const feedbackModalEl = document.getElementById('feedbackModal');
        const gameStage = document.getElementById('game-stage');
        const gameImage = document.getElementById('game-image');
        const gameChoices = document.getElementById('game-choices');
        const progressBar = document.getElementById('progress-bar');

        // --- Instâncias dos Modais Bootstrap ---
        const gameModal = new bootstrap.Modal(gameModalEl);
        const feedbackModal = new bootstrap.Modal(feedbackModalEl);

        // --- Dados do Jogo ---
        const gameData = [{
                image: "{{ asset('img/modulos/modulo1/1.jpg') }}",
                correctAnswer: 1, // 1: PERIGO, 2: RISCO
                feedback: `
      <strong>Por que é <span style="color:#d62828">PERIGO</span>?</strong>
      <ul style="margin:8px 0 0 18px;">
        <li>É a <strong>fonte do dano</strong> — tem potencial de machucar.</li>
        <li><strong>Não há exposição</strong> de pessoas na cena.</li>
        <li>Sem interação, <strong>o risco ainda não existe</strong>.</li>
      </ul>
      <div style="margin-top:8px;color:#475569;">
        <em>Resumo:</em> Perigo = <strong>fonte do problema</strong>. O risco só surge quando alguém se expõe a esse perigo.
      </div>
    `
            },
            {
                image: "{{ asset('img/modulos/modulo1/2.jpg') }}",
                correctAnswer: 2, // 1: PERIGO, 2: RISCO
                feedback: `
      <strong>Por que é <span style="color:#0f7c1c">RISCO</span>?</strong>
      <ul style="margin:8px 0 0 18px;">
        <li>O <strong>perigo</strong> continua sendo o tubarão.</li>
        <li>Agora há <strong>exposição</strong>: uma pessoa está no mesmo ambiente.</li>
        <li>Perigo + Exposição = <strong>aumenta a probabilidade</strong> de ocorrer um dano.</li>
      </ul>
      <div style="margin-top:8px;color:#475569;">
        <em>Resumo:</em> Risco = <strong>Perigo</strong> + <strong>Exposição</strong>. A chance de acidente passa a existir.
      </div>
    `
            }
        ];
        const TOTAL_QUESTIONS = gameData.length;

        // --- Estado do Jogo ---
        let state = {
            currentQuestion: 0,
            score: 0,
            seconds: 0,
            timer: null,
            gameStarted: false,
        };

        // --- Funções de Controle do Modal ---
        window.openGameModal = () => gameModal.show();
        window.closeGameModal = () => gameModal.hide();
        window.closeFeedbackModal = () => {
            feedbackModal.hide();
            // Atraso para a animação do modal de feedback terminar
            setTimeout(loadNextQuestion, 300);
        };

        // --- Lógica do Jogo ---
        function startGame() {
            state.currentQuestion = 0;
            state.score = 0;
            state.seconds = 0;
            state.gameStarted = true;

            updateTimerDisplay();
            startTimer();
            loadQuestion(0);
        }

        function startTimer() {
            if (state.timer) clearInterval(state.timer);
            state.timer = setInterval(() => {
                state.seconds++;
                updateTimerDisplay();
            }, 1000);
        }

        function stopTimer() {
            if (state.timer) clearInterval(state.timer);
            state.timer = null;
        }

        function updateTimerDisplay() {
            document.getElementById('timerLabel').innerHTML = `<i class="fa fa-clock me-1"></i> ${state.seconds}s`;
        }

        function updateProgressIndicator(questionIndex) {
            const progressPercentage = (questionIndex / (TOTAL_QUESTIONS - 1)) * 100;
            progressBar.style.width = `${progressPercentage}%`;

            for (let i = 0; i < TOTAL_QUESTIONS; i++) {
                const dot = document.getElementById(`dot${i + 1}`);
                if (dot) {
                    dot.classList.toggle('is-active', i <= questionIndex);
                }
            }
        }

        function loadQuestion(index) {
            gameStage.classList.add('is-loading'); // Inicia animação de saída

            setTimeout(() => {
                const question = gameData[index];
                gameImage.src = question.image;
                gameImage.alt = `Cena ${index + 1}`;

                // Limpa e recria os botões de escolha
                gameChoices.innerHTML = '';
                const choicesText = ['PERIGO', 'RISCO'];
                choicesText.forEach((text, i) => {
                    const button = document.createElement('button');
                    button.type = 'button';
                    button.className = 'choice';
                    button.dataset.answer = i + 1;
                    button.textContent = text;
                    button.onclick = () => checkAnswer(i + 1);
                    gameChoices.appendChild(button);
                });

                updateProgressIndicator(index);
                gameStage.classList.remove('is-loading'); // Inicia animação de entrada
            }, 300);
        }

        function checkAnswer(selectedAnswer) {
            const question = gameData[state.currentQuestion];
            const isCorrect = selectedAnswer === question.correctAnswer;

            if (isCorrect) {
                state.score++;
            }

            // Desabilita botões e mostra feedback visual
            const buttons = gameChoices.querySelectorAll('.choice');
            buttons.forEach(button => {
                button.disabled = true;
                const answerValue = parseInt(button.dataset.answer);
                if (answerValue === question.correctAnswer) {
                    button.classList.add('correct');
                } else {
                    button.classList.add('incorrect');
                }
            });

            // Atraso para o jogador ver o feedback no botão antes de mostrar o modal
            setTimeout(() => showFeedback(isCorrect, question.feedback), 800);
        }

        function showFeedback(isCorrect, text) {
            const iconContainer = document.getElementById('feedback-icon-container');
            const title = document.getElementById('feedback-title');
            const feedbackText = document.getElementById('feedback-text');

            if (isCorrect) {
                iconContainer.innerHTML = '<div class="feedback-icon success"><i class="fa fa-check"></i></div>';
                title.textContent = "Resposta Correta!";
            } else {
                iconContainer.innerHTML = '<div class="feedback-icon danger"><i class="fa fa-times"></i></div>';
                title.textContent = "Resposta Incorreta";
            }
            feedbackText.innerHTML = text; // Usamos innerHTML para renderizar o <strong>
            feedbackModal.show();
        }

        function loadNextQuestion() {
            state.currentQuestion++;
            if (state.currentQuestion < TOTAL_QUESTIONS) {
                loadQuestion(state.currentQuestion);
            } else {
                endGame();
            }
        }

        function endGame() {
            stopTimer();
            const concluded = state.score >= TOTAL_QUESTIONS ? 1 : 0;

            // Preenche o formulário
            document.getElementById('inputAcertos').value = state.score;
            document.getElementById('inputTempo').value = state.seconds;
            document.getElementById('inputConcluido').value = concluded;
            document.getElementById('inputTotal').value = TOTAL_QUESTIONS;

            // Envia o formulário
            document.getElementById('gameForm').submit();
        }

        // --- Event Listeners do Modal ---
        gameModalEl.addEventListener('show.bs.modal', startGame);
        gameModalEl.addEventListener('hide.bs.modal', () => {
            if (state.gameStarted) {
                stopTimer();
                state.gameStarted = false;
            }
        });

    });
</script>

@endsection