@extends('layouts.main')

@section('title', 'SafetyStart - Minuto da Percepção')

@section('content')

{{-- Título da Página --}}

{{-- Alertas de Sucesso ou Erro --}}
@if (session('success'))
<div class="alert alert-success text-center shadow-sm">{{ session('success') }}</div>
@endif
@if (session('error'))
<div class="alert alert-danger text-center shadow-sm">{{ session('error') }}</div>
@endif

{{-- Card Principal com Conteúdo --}}
<div class="card shadow-sm" style="border-radius: 15px;">
    <div class="card-body p-4">
                        <h2 class="titlequinta mb-4">Minuto da Percepção | Quinta-feira</h2>

        <div class="row">

            {{-- Coluna do Vídeo (Esquerda) --}}
            <div class="col-lg-8 mb-4 mb-lg-0">
                <div class="ratio ratio-16x9" style="border-radius: 10px; overflow: hidden;">
                    <iframe 
                        src="https://player.vimeo.com/video/1110185402?h=c744a5dd80&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479"  
                        frameborder="0" 
                        allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" 
                        referrerpolicy="strict-origin-when-cross-origin" 
                        title="Minuto da Percepção - Dia 02">
                    </iframe>
                </div>
            </div>

            {{-- Coluna de Texto e Avaliação (Direita) --}}
            <div class="col-lg-4 d-flex flex-column justify-content-center">
                
                {{-- Novo Texto Lateral --}}
                <div class="mb-4">
                    <p class="textModulo">Você está prestes a dar um passo importante na sua jornada de aprendizado! Assista ao vídeo e aproveite a dica valiosa sobre percepção de risco no ambiente de trabalho.</p>
                    <p class="textModulo">Lembre-se: ao concluir a visualização do vídeo, você deverá realizar a avaliação para registrar seu progresso.</p>
                    <p class="textModulo fw-bold">Pronto para aprimorar sua percepção de risco? Vamos lá!</p>
                </div>

                {{-- Lógica de Visualização e Avaliação --}}
                @php
                    $visualizado = Auth::user()->usu_min4 != 0;
                    // Removido $nota pois $visualizado já controla o estado
                @endphp

                {{-- Mensagem para quem já concluiu --}}
                @if ($visualizado == 1)
                    <div class="alert alert-info text-center" role="alert" style="border-radius:10px;">
                        Você já concluiu esta etapa. Parabéns!
                    </div>
                {{-- Formulário de Avaliação --}}
                @else
                    <form method="POST" action="{{ route('minutos.avaliar', ['minuto' => 2]) }}">
                        @csrf
                        <div class="text-center mb-3">
                            <label class="form-label fw-bold">Avalie o conteúdo de 1 a 5:</label>
                        </div>
                        <div class="d-flex justify-content-center btn-group mb-4" role="group" aria-label="Notas de avaliação">
                            @for ($i = 1; $i <= 5; $i++)
                                <input type="radio" name="nota" value="{{ $i }}" id="nota{{ $i }}" class="btn-check" required>
                                <label class="btn btn-outline-primary" for="nota{{ $i }}">{{ $i }}</label>
                            @endfor
                        </div>
                        <button type="submit" class="btn btn-success w-100" style="border-radius: 10px; padding: 12px 16px; font-weight: bold;">
                            <i class="bi bi-check-circle-fill me-2"></i> Enviar Avaliação
                        </button>
                    </form>
                @endif
            </div>

        </div>
    </div>
</div>

{{-- Script do Player Vimeo --}}
<script src="https://player.vimeo.com/api/player.js"></script>

@endsection