@extends('layouts.main')

@section('title', 'SafetyStart - Termos de Uso, Política de Privacidade e Regulamento')

@section('content')
<div class="container mx-auto px-4 py-8">
    
    <div class="bg-white rounded-lg shadow-lg p-6 md:p-8">

        <div class="border-b border-gray-200 mb-6">
            <nav class="-mb-px flex space-x-4 overflow-x-auto" aria-label="Tabs">
                <button class="tab-button active" data-target="termos">
                    Termos de Uso
                </button>
                <button class="tab-button" data-target="privacidade">
                    Política de Privacidade
                </button>
                <button class="tab-button" data-target="regulamento">
                    Regulamento
                </button>
            </nav>
        </div>

        <div>
            <section id="termos" class="tab-content active">
                <h2 class="text-xl font-semibold text-gray-800 mb-6 titleItems">Termos de Uso</h2>
                
                <div class="space-y-6 text-gray-700">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">1. Aceitação dos Termos</h3>
                        <p class="mt-2">1.1. Ao acessar e utilizar o aplicativo SafetyStart, você concorda com os presentes Termos de Uso. Se você não concorda com estes termos, por favor, não utilize o aplicativo.</p>
                        <p class="mt-2">1.2. Estes Termos de Uso estão sujeitos a modificações a qualquer momento. Notificações sobre alterações serão enviadas aos usuários cadastrados.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">2. Inscrição e Acesso</h3>
                        <p class="mt-2">2.1. A inscrição no SafetyStart é gratuita e aberta a todos os empregados STELLANTIS das unidades Betim, PWT e Mopar, durante o período de 18 de agosto a 31 de agosto.</p>
                        <p class="mt-2">2.2. Apenas os usuários cadastrados entre 18 de agosto a 22 de agosto terão acesso ao aplicativo no período de 18/08 a 31/08.</p>
                        <p class="mt-2">2.3. O usuário deve fornecer informações precisas e completas ao se cadastrar no aplicativo, garantindo a idoneidade das informações.</p>
                        <p class="mt-2">2.4. Cada usuário é responsável por manter a confidencialidade de suas credenciais de acesso.</p>
                        <p class="mt-2">2.5. A inscrição e o acesso ao aplicativo devem ser realizados de forma segura, respeitando as diretrizes internas da STELLANTIS para o uso de dispositivos eletrônicos no ambiente de trabalho.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">3. Requisitos de Acesso e Uso</h3>
                        <p class="mt-2">3.1. Para utilizar o SafetyStart, é necessário que o usuário tenha um dispositivo compatível com acesso à internet.</p>
                        <p class="mt-2">3.2. O uso do aplicativo pode consumir pacote de dados móveis. Verifique com sua operadora as tarifas aplicáveis.</p>
                        <p class="mt-2">3.3. Os vídeos utilizados nos módulos são hospedados na plataforma Vimeo, portanto, é necessário que o usuário tenha acesso liberado a esta plataforma para assistir aos vídeos.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">4. Métodos de Uso com Segurança</h3>
                        <p class="mt-2">4.1. O uso do aplicativo deve ser realizado em ambiente seguro, sem comprometer a atenção e a segurança do usuário ou de outros.</p>
                        <p class="mt-2">4.2. É proibido o uso do aplicativo enquanto o empregado estiver operando máquinas ou em atividades que demandem atenção total.</p>
                        <p class="mt-2">4.3. Siga as diretrizes internas da STELLANTIS para o uso de dispositivos eletrônicos no ambiente de trabalho.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">5. Funcionalidades e Limites de Uso</h3>
                        <p class="mt-2">5.1. Módulos da Trilha do Conhecimento: Compreendem vídeos, textos e quizzes sobre as Perigo x Risco, Principais Riscos Críticos, NR 12 - Seg. Máq. e Equipamentos, ARPT Análise de Risco e Permissão de Trabalho, Pirâmide Invertida Hierarquia de Controle de Risco.</p>
                        <p class="mt-2">5.2. Desafio Diário: Disponíveis entre 18/08 a 22/08, com uma desafio diário que pode ser respondido para ganhar pontos adicionais.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">6. Capacidade de Usuários e Fila de Acesso</h3>
                        <p class="mt-2">6.1. O SafetyStart suporta até 1000 acessos simultâneos.</p>
                        <p class="mt-2">6.2. Caso o número de acessos simultâneos exceda este limite, os usuários serão colocados em uma fila de espera e poderão acessar o aplicativo assim que houver disponibilidade.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">7. Privacidade e Segurança da Informação</h3>
                        <p class="mt-2">7.1. Proteção de Dados: O SafetyStart, desenvolvido pela AB Tecnologia, se compromete a proteger a privacidade dos usuários e a segurança dos dados pessoais fornecidos.</p>
                        <p class="mt-2">7.2. Logs e Rastreamento de Uso: O sistema mantém logs e rastreia o uso do aplicativo para garantir a segurança e a conformidade com os termos de uso.</p>
                        <p class="mt-2">7.3. Uso de Informações: As informações coletadas serão utilizadas exclusivamente para os fins do aplicativo e internamente na STELLANTIS, em conformidade com as leis vigentes de proteção de dados.</p>
                        <p class="mt-2">7.4. Compartilhamento de Dados: As informações dos usuários não serão compartilhadas com terceiros, exceto quando exigido por lei ou com o consentimento expresso do usuário.</p>
                        <p class="mt-2">7.5. Recuperação de Senha: O sistema de recuperação de senha será realizado através do e-mail cadastrado pelo usuário no momento da inscrição.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">8. Segurança no Desenvolvimento e Manutenção</h3>
                        <p class="mt-2">8.1. Atualizações de Segurança: A AB Tecnologia se compromete a realizar atualizações regulares no aplicativo para garantir sua segurança e eficiência.</p>
                        <p class="mt-2">8.2. Testes de Vulnerabilidade: O aplicativo será submetido a testes periódicos de vulnerabilidade para identificar e corrigir possíveis falhas de segurança.</p>
                        <p class="mt-2">8.3. Responsabilidade da AB Tecnologia: A AB Tecnologia é responsável por garantir que o aplicativo esteja em conformidade com as melhores práticas de segurança da informação.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">9. Suporte ao Usuário</h3>
                        <p class="mt-2">9.1. Sistema de Suporte: O aplicativo possui um menu específico para suporte, onde os usuários podem gerar tickets para reportar problemas ou dúvidas.</p>
                        <p class="mt-2">9.2. Respostas aos Tickets: Os tickets gerados serão respondidos por e-mail pela equipe de suporte do SafetyStart dentro de um prazo de até 48 horas.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">10. Conduta dos Usuários</h3>
                        <p class="mt-2">10.1. É proibido o uso de informações falsas ou enganosas no aplicativo.</p>
                        <p class="mt-2">10.2. Os usuários devem respeitar os termos de uso e agir de maneira ética e profissional.</p>
                        <p class="mt-2">10.3. Qualquer tentativa de manipulação do sistema ou de ganho de pontos de forma ilícita será considerada uma violação grave e poderá resultar na exclusão do usuário do aplicativo.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">11. Modificações nos Termos de Uso</h3>
                        <p class="mt-2">11.1. O SafetyStart reserva-se o direito de modificar estes Termos de Uso a qualquer momento. Notificações sobre alterações serão enviadas aos usuários cadastrados.</p>
                        <p class="mt-2">11.2. As alterações entrarão em vigor imediatamente após a notificação. O uso contínuo do aplicativo após a alteração constitui a aceitação dos novos termos.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">12. Disposições Gerais</h3>
                        <p class="mt-2">12.1. Estes Termos de Uso são regidos pelas leis vigentes no Brasil.</p>
                        <p class="mt-2">12.2. Estes Termos de Uso seguem as regras STELLANTIS e as políticas internas de segurança da informação da AB Tecnologia.</p>
                        <p class="mt-2">12.3. Quaisquer dúvidas ou questões relacionadas aos Termos de Uso devem ser encaminhadas à equipe de suporte do SafetyStart.</p>
                        <p class="mt-2">12.4. O uso do aplicativo implica na aceitação total destes Termos de Uso por parte do usuário.</p>
                    </div>
                </div>
            </section>

            <section id="privacidade" class="tab-content hidden">
                <h2 class="text-xl font-semibold text-gray-800 mb-6 titleItems">Política de Privacidade</h2>
                
                <div class="space-y-6 text-gray-700">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">1. Introdução</h3>
                        <p class="mt-2">1.1. Esta Política de Privacidade descreve como o aplicativo SafetyStart coleta, usa, armazena e protege as informações pessoais dos usuários.</p>
                        <p class="mt-2">1.2. Ao utilizar o aplicativo SafetyStart, você concorda com as práticas descritas nesta Política de Privacidade. Se você não concorda com os termos aqui apresentados, por favor, não utilize o aplicativo.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">2. Coleta de Informações</h3>
                        <p class="mt-2">2.1. O aplicativo coleta informações pessoais fornecidas diretamente pelos usuários durante o processo de cadastro, incluindo nome, e-mail, e informações relacionadas ao ambiente de trabalho.</p>
                        <p class="mt-2">2.2. Informações adicionais podem ser coletadas automaticamente, como logs de uso, tipo de dispositivo e dados de conexão à internet, para fins de segurança e análise.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">3. Uso das Informações</h3>
                        <p class="mt-2">3.1. As informações coletadas serão utilizadas exclusivamente para as finalidades do aplicativo, como cadastro de usuários, acompanhamento de progresso nos módulos, registro de condições inseguras, e participação em rankings e sorteios.</p>
                        <p class="mt-2">3.2. Os dados poderão ser usados para melhorar a experiência do usuário, personalizar o conteúdo e realizar atualizações no aplicativo.</p>
                        <p class="mt-2">3.3. Os dados pessoais não serão utilizados para finalidades distintas daquelas especificadas sem o consentimento prévio do usuário.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">4. Armazenamento e Proteção de Dados</h3>
                        <p class="mt-2">4.1. Todos os dados coletados são armazenados em servidores seguros e são protegidos por medidas técnicas e organizacionais adequadas para evitar acesso não autorizado, perda ou divulgação indevida.</p>
                        <p class="mt-2">4.2. O SafetyStart utiliza criptografia e outras tecnologias de segurança para proteger as informações pessoais dos usuários.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">5. Compartilhamento de Informações</h3>
                        <p class="mt-2">5.1. As informações dos usuários serão compartilhadas apenas com a equipe responsável pelo desenvolvimento do aplicativo (AB Tecnologia) e com o time da STELLANTIS responsável pela gestão do aplicativo.</p>
                        <p class="mt-2">5.2. Os dados não serão compartilhados com terceiros, exceto quando exigido por lei ou com o consentimento expresso do usuário.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">6. Direitos dos Usuários</h3>
                        <p class="mt-2">6.1. Os usuários têm o direito de acessar, corrigir ou excluir suas informações pessoais a qualquer momento. Solicitações devem ser enviadas ao suporte do aplicativo.</p>
                        <p class="mt-2">6.2. Os usuários podem, a qualquer momento, optar por revogar seu consentimento para o uso de dados pessoais, sendo que isso pode limitar o uso do aplicativo.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">7. Retenção de Dados</h3>
                        <p class="mt-2">7.1. Os dados pessoais serão mantidos pelo período necessário para cumprir as finalidades estabelecidas nesta Política de Privacidade, ou conforme exigido por lei.</p>
                        <p class="mt-2">7.2. Após a conclusão do uso do aplicativo, incluindo o sorteio e entrega de prêmios, todos os dados pessoais serão permanentemente excluídos.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">8. Modificações na Política de Privacidade</h3>
                        <p class="mt-2">8.1. O SafetyStart reserva-se o direito de modificar esta Política de Privacidade a qualquer momento. Notificações sobre alterações serão enviadas aos usuários cadastrados.</p>
                        <p class="mt-2">8.2. As alterações entrarão em vigor imediatamente após a notificação. O uso contínuo do aplicativo após a alteração constitui a aceitação dos novos termos.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">9. Contato</h3>
                        <p class="mt-2">9.1. Para quaisquer dúvidas ou questões relacionadas a esta Política de Privacidade, entre em contato com a equipe de suporte do SafetyStart através do menu de suporte no aplicativo ou através do e-mail suporte@safetystart.app.br.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">10. Disposições Gerais</h3>
                        <p class="mt-2">10.1. Esta Política de Privacidade é regida pelas leis vigentes no Brasil.</p>
                        <p class="mt-2">10.2. O uso do aplicativo implica na aceitação total desta Política de Privacidade por parte do usuário.</p>
                    </div>
                </div>
            </section>

            <section id="regulamento" class="tab-content hidden">
                <h2 class="text-xl font-semibold text-gray-800 mb-6 titleItems">Regulamento do Aplicativo SafetyStart - STELLANTIS</h2>
                
                <div class="space-y-6 text-gray-700">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">1. Objetivo</h3>
                        <p class="mt-2">O aplicativo SafetyStart tem como objetivo promover a educação em segurança do trabalho durante a SIPAT 2025, incentivando os usuários a aprenderem e aplicarem os conhecimentos adquiridos através de módulos sobre Percepção de Risco.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">2. Inscrição e Acesso</h3>
                        <p class="mt-2">2.1. A inscrição no SafetyStart é gratuita e aberta a todos os empregados STELLANTIS.</p>
                        <p class="mt-2">2.2. O período de cadastro no aplicativo será de 12/08 a 22/08.</p>
                        <p class="mt-2">2.3. Apenas os usuários cadastrados entre 12/08 e 22/08 terão acesso ao aplicativo no período de 12/08 a 31/08.</p>
                        <p class="mt-2">2.4. O usuário deve fornecer informações precisas e completas ao se cadastrar no aplicativo, garantindo a idoneidade das informações.</p>
                        <p class="mt-2">2.5. Cada usuário é responsável por manter a confidencialidade de suas credenciais de acesso.</p>
                        <p class="mt-2">2.6. O uso do aplicativo deve ser realizado de forma segura, seguindo as diretrizes internas da STELLANTIS para o uso de dispositivos eletrônicos no ambiente de trabalho.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">3. Trilha do Conhecimento</h3>
                        <p class="mt-2">3.1. O aplicativo oferece diversos módulos de conhecimento.</p>
                        <p class="mt-2">3.2. Cada módulo inclui vídeos, textos e jogos para validar o conhecimento adquirido.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">4. Perguntas Diárias</h3>
                        <p class="mt-2">4.1. O SafetyStart oferece uma pergunta diária que os usuários podem responder para ganhar pontos adicionais. As perguntas diárias serão disponibilizadas entre os dias 18 e 22 de agosto.</p>
                        <p class="mt-2">4.2. Cada pergunta diária estará disponível por um período de 24 horas.</p>
                        <p class="mt-2">4.3. Respostas corretas às perguntas diárias geram pontos que são acumulados na conta do usuário.</p>
                        <p class="mt-2">4.4. A pergunta bônus só poderá ser respondida uma vez por dia.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">5. Pontuação</h3>
                        <p class="mt-2">5.1. Distribuição de pontos:</p>
                        <ul class="list-disc pl-6 space-y-2 mt-2 bg-gray-50 p-4 rounded-md">
                            <li><strong>10 pontos</strong> por módulo da trilha do conhecimento</li>
                            <li><strong>5 pontos</strong> por minuto da segurança assistido</li>
                            <li><strong>5 pontos</strong> desafio diário respondido corretamente</li>
                        </ul>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">6. Uso Correto do Aplicativo e Dispositivos Eletrônicos</h3>
                        <p class="mt-2">6.1. Ambiente Seguro: O uso do aplicativo deve ser realizado em um ambiente seguro, sem comprometer a atenção e a segurança do empregado ou de outros.</p>
                        <p class="mt-2">6.2. Diretrizes para Dispositivos Móveis:</p>
                        <ul class="list-disc pl-6 space-y-2 mt-2">
                           <li>O uso de dispositivos móveis deve seguir as diretrizes internas da STELLANTIS, especialmente em áreas produtivas e de risco.</li>
                           <li>Não é permitido o uso do aplicativo enquanto o empregado estiver operando máquinas ou em atividades que demandem atenção total.</li>
                        </ul>
                        <p class="mt-2">6.3. Informações Falsas: É proibido o uso de informações falsas ou enganosas no aplicativo.</p>
                        <p class="mt-2">6.4. Comportamento Ético: Os usuários devem respeitar os termos de uso e agir de maneira ética e profissional.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">7. Privacidade e Segurança da Informação</h3>
                        <p class="mt-2">7.1. Proteção de Dados: O SafetyStart se compromete a proteger a privacidade dos usuários e a segurança dos dados pessoais fornecidos.</p>
                        <p class="mt-2">7.2. Uso de Informações: As informações coletadas serão utilizadas exclusivamente para os fins do aplicativo e internamente pelo time de WHS da STELLANTIS.</p>
                        <p class="mt-2">7.3. Conformidade: Todas as práticas de coleta e processamento de dados estão em conformidade com as leis vigentes de proteção de dados.</p>
                        <p class="mt-2">7.4. Uso e tratamento dos dados: Os dados pessoais aqui fornecidos serão utilizados para as finalidades de cadastro no game e análise das respostas fornecidas.</p>
                        <p class="mt-2">7.5. Término de uso de dados: Todos seus dados serão apagados após o término da aplicação, ou seja, após a realização do sorteio e entrega dos prêmios.</p>
                        <p class="mt-2">7.6. Compartilhamento de dados: Os dados serão utilizados apenas pelo time de desenvolvimento AB Marketing e Tech e compartilhados apenas com o time STELLANTIS responsável pela contratação da aplicação.</p>
                    </div>
                     <div>
                        <h3 class="text-lg font-semibold text-gray-800">8. Modificações no Regulamento</h3>
                        <p class="mt-2">8.1. O SafetyStart reserva-se o direito de modificar este regulamento a qualquer momento, mediante aviso prévio aos usuários.</p>
                    </div>
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800">9. Disposições Gerais</h3>
                        <p class="mt-2">9.1. Este regulamento é regido pelas leis vigentes no Brasil.</p>
                        <p class="mt-2">9.2. Este regulamento segue as regras STELLANTIS.</p>
                        <p class="mt-2">9.3. Quaisquer dúvidas ou questões relacionadas ao regulamento devem ser encaminhadas à equipe de suporte do SafetyStart.</p>
                        <p class="mt-2">9.4. O uso do aplicativo implica na aceitação total deste regulamento por parte do usuário.</p>
                    </div>
                </div>
            </section>
        </div>

    </div>
</div>

@endsection

{{-- 
    ======================================================================
    ||   LEMBRETE: Adicionar o CSS e o JavaScript abaixo              ||
    ======================================================================
--}}

{{-- Adicione ao seu arquivo CSS --}}
<style>
    .tab-button {
        padding: 0.75rem 1rem; /* 12px 16px */
        font-size: 1rem; /* 16px */
        font-weight: 600;
        color: #4a5568; /* Cinza escuro para abas inativas */
        border-bottom: 3px solid transparent;
        transition: all 0.2s ease;
        cursor: pointer;
        white-space: nowrap;
    }

    .tab-button:hover {
        color: #2c3e50;
        background-color: #f7fafc; /* Um fundo suave no hover */
    }

    .tab-button.active {
        color: #003F82; /* Cor principal do sistema */
        border-bottom-color: #07509D; /* Cor de destaque, igual à borda do título */
    }

    .tab-content {
        animation: fadeIn 0.4s ease-in-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
</style>


{{-- Adicione antes do fechamento da tag </body> --}}
<script>
document.addEventListener('DOMContentLoaded', function () {
    const tabButtons = document.querySelectorAll('.tab-button');
    const tabContents = document.querySelectorAll('.tab-content');

    tabButtons.forEach(button => {
        button.addEventListener('click', () => {
            // Remove a classe 'active' de todos os botões e conteúdos
            tabButtons.forEach(btn => btn.classList.remove('active'));
            tabContents.forEach(content => {
                content.classList.add('hidden');
                content.classList.remove('active');
            });

            // Adiciona a classe 'active' ao botão clicado
            button.classList.add('active');

            // Exibe o conteúdo correspondente
            const targetId = button.getAttribute('data-target');
            const targetContent = document.getElementById(targetId);
            
            if (targetContent) {
                targetContent.classList.remove('hidden');
                targetContent.classList.add('active');
            }
        });
    });
});
</script>