@extends('layouts.main')

@section('title', 'SafetyStart - Pergunta Diária 5')

@section('content')
<div id="pergunta5">
  <div class="q-container">

    {{-- Hero com o gradiente do Módulo 5 --}}
    <header class="q-hero bodyModulo5">
      <div class="q-hero-top">
        <span class="q-chip"><i class="fa fa-calendar-day me-1"></i> Dia 5</span>
        <span class="q-chip q-chip--ghost"><i class="fa fa-triangle-exclamation me-1"></i> Pirâmide Invertida</span>
      </div>
      <h1 class="q-title">
        Segundo a Hierarquia de Controle de Riscos (Pirâmide Invertida), qual é a abordagem correta ao escolher controles?
      </h1>
    </header>

    {{-- Feedback padrão --}}
    @if (session('success'))
      <div class="alert alert-success q-alert">{{ session('success') }}</div>
    @elseif (session('error'))
      <div class="alert alert-danger q-alert">{{ session('error') }}</div>
    @endif

    @php
      // A alternativa correta deve ter value=1. Embaralhar ordem a cada load.
      $opcoes = [
        [
          'value' => 1,
          'text'  => 'Priorizar primeiro as soluções do topo da pirâmide (ELIMINAR o perigo e, se não for possível, SUBSTITUIR), antes de partir para controles de ENGENHARIA, ADMINISTRATIVOS e, por último, EPI.',
        ],
        [
          'value' => 2,
          'text'  => 'Começar pelo uso de EPI e, se ainda restar risco, avaliar depois controles administrativos, engenharia, substituição e eliminação.',
        ],
        [
          'value' => 3,
          'text'  => 'Escolher o controle mais rápido e barato disponível, mesmo que seja apenas EPI, para não atrasar a operação.',
        ],
      ];
      shuffle($opcoes);
    @endphp

    <form method="POST" action="{{ route('update.resposta.diaria', ['diaria' => 5]) }}" class="q-card">
      @csrf

      @foreach ($opcoes as $idx => $opt)
        @php $id = 'opt5_' . $idx; @endphp
        <label class="q-option" for="{{ $id }}">
          <input id="{{ $id }}" type="radio" name="resposta" value="{{ $opt['value'] }}" {{ old('resposta') == $opt['value'] ? 'checked' : '' }}>
          <span class="q-radio"></span>
          <span class="q-option-text">{{ $opt['text'] }}</span>
        </label>
      @endforeach

      <div class="q-actions">
        <a href="/diarias" class="btn q-btn q-btn--ghost">
          <i class="fa fa-arrow-left me-2"></i> Voltar
        </a>
        <button type="submit" class="btn q-btn">
          Enviar <i class="fa fa-paper-plane ms-2"></i>
        </button>
      </div>
    </form>

    {{-- Dica opcional --}}
    <p class="q-hint">
      Lembre-se: <strong>eliminar</strong> e <strong>substituir</strong> vêm antes. Controles de <strong>engenharia</strong> e <strong>administrativos</strong> fortalecem a barreira. <strong>EPI</strong> é a última linha de defesa.
    </p>

  </div>
</div>

<style>
/* ===== Estilos escopados (mesmo look das demais perguntas) ===== */
#pergunta5{ --brand:#0f8d85; --accent:#1691ff; --text:#1f2430; }
#pergunta5 .q-container{ max-width:960px; margin:8px auto 24px; padding:0 8px; }

#pergunta5 .q-hero{
  position:relative; border-radius:20px; padding:22px 22px 18px; color:#fff;
  box-shadow:0 14px 30px rgba(0,0,0,.12);
}
#pergunta5 .q-hero:after{
  content:""; position:absolute; inset:0; border-radius:20px;
  background:linear-gradient(180deg, rgba(0,0,0,.06), rgba(0,0,0,.25));
  pointer-events:none;
}
#pergunta5 .q-hero-top{ display:flex; gap:8px; justify-content:space-between; align-items:center; margin-bottom:6px; }
#pergunta5 .q-chip{
  display:inline-flex; align-items:center; gap:6px; font-weight:800; font-size:12px;
  padding:6px 10px; border-radius:999px; background:rgba(0,0,0,.32); color:#fff;
  box-shadow: inset 0 0 0 1px rgba(255,255,255,.08);
}
#pergunta5 .q-chip--ghost{ background:rgba(0,0,0,.22); }
#pergunta5 .q-title{ margin:0; font-size:22px; line-height:1.25; font-weight:900; text-shadow:0 1px 0 rgba(0,0,0,.18); }

#pergunta5 .q-card{
  background:#fff; border:1px solid rgba(0,0,0,.06); border-radius:16px;
  padding:16px; margin-top:14px; box-shadow:0 8px 22px rgba(0,0,0,.06);
}

#pergunta5 .q-option{
  display:flex; align-items:flex-start; gap:12px; padding:12px 10px; border-radius:12px;
  border:1px solid rgba(0,0,0,.06); cursor:pointer; transition:.15s ease;
  margin-bottom:10px; background:#fff;
}
#pergunta5 .q-option:hover{ box-shadow:0 8px 20px rgba(0,0,0,.06); transform: translateY(-1px); }
#pergunta5 .q-option input{ appearance:none; width:0; height:0; position:absolute; }
#pergunta5 .q-radio{
  width:18px; height:18px; border-radius:50%; border:2px solid #0a6f6d;
  display:inline-block; position:relative; top:3px; flex:0 0 18px;
}
#pergunta5 .q-option input:checked + .q-radio{ border-color:var(--accent); }
#pergunta5 .q-option input:checked + .q-radio:after{
  content:""; position:absolute; inset:3px; border-radius:50%; background:var(--accent);
}
#pergunta5 .q-option-text{ color:var(--text); line-height:1.5; }

#pergunta5 .q-actions{ display:flex; justify-content:space-between; gap:10px; margin-top:8px; }
#pergunta5 .q-btn{
  background:var(--accent); color:#fff; font-weight:800; border:none;
  border-radius:999px; padding:10px 18px; box-shadow:0 10px 22px rgba(22,145,255,.25);
}
#pergunta5 .q-btn:hover{ filter:brightness(1.05); }
#pergunta5 .q-btn--ghost{
  background:#e9fbf9; color:#014a4b; border:1px solid #cfeceb; box-shadow:none;
}
#pergunta5 .q-btn--ghost:hover{ background:#dff6f4; }

#pergunta5 .q-alert{ margin-top:12px; border-radius:12px; }
#pergunta5 .q-hint{ font-size:14px; color:#4b4f59; margin-top:10px; }

@media (max-width:576px){
  #pergunta5 .q-title{ font-size:18px; }
}
</style>
@endsection
