@extends('layouts.main')

@section('title', 'SafetyStart - Pergunta Diária 3')

@section('content')
<div id="pergunta3">
  <div class="q-container">

    {{-- Hero com o gradiente do Módulo 3 --}}
    <header class="q-hero bodyModulo3">
      <div class="q-hero-top">
        <span class="q-chip"><i class="fa fa-calendar-day me-1"></i> Dia 3</span>
        <span class="q-chip q-chip--ghost"><i class="fa fa-shield-halved me-1"></i> NR 12</span>
      </div>
      <h1 class="q-title">
        Segundo a <span class="q-strong">NR 12</span> e as responsabilidades do trabalhador, qual alternativa está <u>correta</u>?
      </h1>
    </header>

    {{-- Mensagens de feedback (opcional) --}}
    @if (session('success'))
      <div class="alert alert-success q-alert">{{ session('success') }}</div>
    @elseif (session('error'))
      <div class="alert alert-danger q-alert">{{ session('error') }}</div>
    @endif

    @php
      // value=1 é a correta. Embaralhar a ordem a cada load.
      $opcoes = [
        [
          'value' => 1,
          'text'  => 'A máquina <strong>não deve operar</strong> com proteções físicas abertas/removidas; o trabalhador deve <strong>checar as proteções</strong> antes de iniciar, <strong>nunca burlar</strong> dispositivos de segurança e <strong>comunicar falhas</strong> imediatamente.',
        ],
        [
          'value' => 2,
          'text'  => 'Se houver vigilância próxima, a máquina pode operar com proteções abertas e o trabalhador pode <em>burlar</em> sensores em situações de urgência.',
        ],
        [
          'value' => 3,
          'text'  => 'A NR 12 trata apenas de EPIs e não contempla sensores ou guardas; a verificação de segurança é responsabilidade exclusiva da manutenção.',
        ],
      ];
      shuffle($opcoes);
    @endphp

    <form method="POST" action="{{ route('update.resposta.diaria', ['diaria' => 3]) }}" class="q-card">
      @csrf

      @foreach ($opcoes as $idx => $opt)
        @php $id = 'opt3_' . $idx; @endphp
        <label class="q-option" for="{{ $id }}">
          <input id="{{ $id }}" type="radio" name="resposta" value="{{ $opt['value'] }}" {{ old('resposta') == $opt['value'] ? 'checked' : '' }}>
          <span class="q-radio"></span>
          <span class="q-option-text">{!! $opt['text'] !!}</span>
        </label>
      @endforeach

      <div class="q-actions">
        <a href="/diarias" class="btn q-btn q-btn--ghost">
          <i class="fa fa-arrow-left me-2"></i> Voltar
        </a>
        <button type="submit" class="btn q-btn">
          Enviar <i class="fa fa-paper-plane ms-2"></i>
        </button>
      </div>
    </form>

  </div>
</div>

<style>
/* ===== Estilos escopados (mesmo look das perguntas 1 e 2) ===== */
#pergunta3{ --brand:#3f4047; --accent:#1691ff; --text:#1f2430; }
#pergunta3 .q-container{ max-width:960px; margin:8px auto 24px; padding:0 8px; }

#pergunta3 .q-hero{
  position:relative; border-radius:20px; padding:22px 22px 18px; color:#fff;
  box-shadow:0 14px 30px rgba(0,0,0,.12);
}
#pergunta3 .q-hero:after{
  content:""; position:absolute; inset:0; border-radius:20px;
  background:linear-gradient(180deg, rgba(0,0,0,.06), rgba(0,0,0,.25));
  pointer-events:none;
}
#pergunta3 .q-hero-top{ display:flex; gap:8px; justify-content:space-between; align-items:center; margin-bottom:6px; }
#pergunta3 .q-chip{
  display:inline-flex; align-items:center; gap:6px; font-weight:800; font-size:12px;
  padding:6px 10px; border-radius:999px; background:rgba(0,0,0,.32); color:#fff;
  box-shadow: inset 0 0 0 1px rgba(255,255,255,.08);
}
#pergunta3 .q-chip--ghost{ background:rgba(0,0,0,.22); }
#pergunta3 .q-title{ margin:0; font-size:22px; line-height:1.25; font-weight:900; text-shadow:0 1px 0 rgba(0,0,0,.18); }
#pergunta3 .q-strong{ border-bottom:2px solid rgba(255,255,255,.7); }

#pergunta3 .q-card{
  background:#fff; border:1px solid rgba(0,0,0,.06); border-radius:16px;
  padding:16px; margin-top:14px; box-shadow:0 8px 22px rgba(0,0,0,.06);
}

#pergunta3 .q-option{
  display:flex; align-items:flex-start; gap:12px; padding:12px 10px; border-radius:12px;
  border:1px solid rgba(0,0,0,.06); cursor:pointer; transition:.15s ease;
  margin-bottom:10px; background:#fff;
}
#pergunta3 .q-option:hover{ box-shadow:0 8px 20px rgba(0,0,0,.06); transform: translateY(-1px); }
#pergunta3 .q-option input{ appearance:none; width:0; height:0; position:absolute; }
#pergunta3 .q-radio{
  width:18px; height:18px; border-radius:50%; border:2px solid var(--brand);
  display:inline-block; position:relative; top:3px; flex:0 0 18px;
}
#pergunta3 .q-option input:checked + .q-radio{ border-color:var(--accent); }
#pergunta3 .q-option input:checked + .q-radio:after{
  content:""; position:absolute; inset:3px; border-radius:50%; background:var(--accent);
}
#pergunta3 .q-option-text{ color:var(--text); line-height:1.5; }

#pergunta3 .q-actions{ display:flex; justify-content:space-between; gap:10px; margin-top:8px; }
#pergunta3 .q-btn{
  background:var(--accent); color:#fff; font-weight:800; border:none;
  border-radius:999px; padding:10px 18px; box-shadow:0 10px 22px rgba(22,145,255,.25);
}
#pergunta3 .q-btn:hover{ filter:brightness(1.05); }
#pergunta3 .q-btn--ghost{
  background:#eef3ff; color:#0b3b77; border:1px solid #cfe0ff; box-shadow:none;
}
#pergunta3 .q-btn--ghost:hover{ background:#e6edff; }

#pergunta3 .q-alert{ margin-top:12px; border-radius:12px; }

@media (max-width:576px){
  #pergunta3 .q-title{ font-size:18px; }
}
</style>
@endsection
