@extends('layouts.main')

@section('title', 'SafetyStart - Pergunta Diária 2')

@section('content')
<div id="pergunta2">
  <div class="q-container">
    {{-- Hero com o gradiente do Módulo 2 --}}
    <header class="q-hero bodyModulo2">
      <div class="q-hero-top">
        <span class="q-chip"><i class="fa fa-calendar-day me-1"></i> Dia 2</span>
        <span class="q-chip q-chip--ghost"><i class="fa fa-hourglass-half me-1"></i> Pendente</span>
      </div>
      <h1 class="q-title">
        No contexto de <span class="q-strong">Trabalho em Altura</span>, qual atitude está correta?
      </h1>
    </header>

    {{-- Mensagens --}}
    @if (session('success'))
      <div class="alert alert-success q-alert">{{ session('success') }}</div>
    @elseif (session('error'))
      <div class="alert alert-danger q-alert">{{ session('error') }}</div>
    @endif

    @php
      // Alternativas (value=1 é a correta). Embaralhadas a cada load.
      $opcoes = [
        ['value' => 1, 'text' => 'Verificar o cinto antes do uso e manter-se <strong>conectado 100% do tempo</strong> a um ponto de ancoragem seguro.'],
        ['value' => 2, 'text' => 'Subir primeiro e conectar o cinto apenas ao chegar ao ponto de trabalho, para ganhar agilidade.'],
        ['value' => 3, 'text' => 'Desconectar o cinto rapidamente durante o trabalho, se for preciso reposicionar o corpo.'],
      ];
      shuffle($opcoes);
    @endphp

    {{-- Formulário --}}
    <form method="POST" action="{{ route('update.resposta.diaria', ['diaria' => 2]) }}" class="q-card">
      @csrf

      @foreach ($opcoes as $idx => $opt)
        @php $id = 'opt2_' . $idx; @endphp
        <label class="q-option" for="{{ $id }}">
          <input id="{{ $id }}" type="radio" name="resposta" value="{{ $opt['value'] }}" {{ old('resposta') == $opt['value'] ? 'checked' : '' }}>
          <span class="q-radio"></span>
          <span class="q-option-text">{!! $opt['text'] !!}</span>
        </label>
      @endforeach

      <div class="q-actions">
        <a href="/diarias" class="btn q-btn q-btn--ghost">
          <i class="fa fa-arrow-left me-2"></i> Voltar
        </a>
        <button type="submit" class="btn q-btn">
          Enviar <i class="fa fa-paper-plane ms-2"></i>
        </button>
      </div>
    </form>
  </div>
</div>

<style>
/* ===== Estilos escopados para a página da Pergunta 2 ===== */
#pergunta2{ --brand:#243782; --accent:#1691ff; --text:#1f2430; }
#pergunta2 .q-container{ max-width:960px; margin:8px auto 24px; padding:0 8px; }

/* Hero (usa bodyModulo2 já existente no seu CSS global) */
#pergunta2 .q-hero{
  position:relative; border-radius:20px; padding:22px 22px 18px; color:#fff;
  box-shadow:0 14px 30px rgba(0,0,0,.12);
}
#pergunta2 .q-hero:after{
  content:""; position:absolute; inset:0; border-radius:20px;
  background:linear-gradient(180deg, rgba(0,0,0,.06), rgba(0,0,0,.25));
  pointer-events:none;
}
#pergunta2 .q-hero-top{ display:flex; gap:8px; justify-content:space-between; align-items:center; margin-bottom:6px; }
#pergunta2 .q-chip{
  display:inline-flex; align-items:center; gap:6px; font-weight:800; font-size:12px;
  padding:6px 10px; border-radius:999px; background:rgba(0,0,0,.32); color:#fff;
  box-shadow: inset 0 0 0 1px rgba(255,255,255,.08);
}
#pergunta2 .q-chip--ghost{ background:rgba(0,0,0,.22); }
#pergunta2 .q-title{ margin:0; font-size:22px; line-height:1.25; font-weight:900; text-shadow:0 1px 0 rgba(0,0,0,.18); }
#pergunta2 .q-strong{ border-bottom:2px solid rgba(255,255,255,.7); }

/* Card do formulário */
#pergunta2 .q-card{
  background:#fff; border:1px solid rgba(0,0,0,.06); border-radius:16px;
  padding:16px; margin-top:14px; box-shadow:0 8px 22px rgba(0,0,0,.06);
}

/* Opções */
#pergunta2 .q-option{
  display:flex; align-items:flex-start; gap:12px; padding:12px 10px; border-radius:12px;
  border:1px solid rgba(0,0,0,.06); cursor:pointer; transition:.15s ease;
  margin-bottom:10px; background:#fff;
}
#pergunta2 .q-option:hover{ box-shadow:0 8px 20px rgba(0,0,0,.06); transform: translateY(-1px); }
#pergunta2 .q-option input{ appearance:none; width:0; height:0; position:absolute; }
#pergunta2 .q-radio{
  width:18px; height:18px; border-radius:50%; border:2px solid var(--brand);
  display:inline-block; position:relative; top:3px; flex:0 0 18px;
}
#pergunta2 .q-option input:checked + .q-radio{ border-color:var(--accent); }
#pergunta2 .q-option input:checked + .q-radio:after{
  content:""; position:absolute; inset:3px; border-radius:50%; background:var(--accent);
}
#pergunta2 .q-option-text{ color:var(--text); line-height:1.5; }

/* Ações */
#pergunta2 .q-actions{ display:flex; justify-content:space-between; gap:10px; margin-top:8px; }
#pergunta2 .q-btn{
  background:var(--accent); color:#fff; font-weight:800; border:none;
  border-radius:999px; padding:10px 18px; box-shadow:0 10px 22px rgba(22,145,255,.25);
}
#pergunta2 .q-btn:hover{ filter:brightness(1.05); }
#pergunta2 .q-btn--ghost{
  background:#eef3ff; color:#0b3b77; border:1px solid #cfe0ff; box-shadow:none;
}
#pergunta2 .q-btn--ghost:hover{ background:#e6edff; }

/* Mensagens */
#pergunta2 .q-alert{ margin-top:12px; border-radius:12px; }

/* Responsivo */
@media (max-width:576px){
  #pergunta2 .q-title{ font-size:18px; }
}
</style>
@endsection
