@extends('layouts.main')

@section('title', 'SafetyStart - Início')

@section('content')

<div id="home">

  {{-- HERO claro (tom de branco) --}}
  <section class="home-hero home-hero--light">
    <div class="home-hero__content">
      <div class="home-hero__chips">
        <span class="home-chip home-chip--brand"><i class="fa fa-shield-alt me-1"></i> Segurança em primeiro lugar</span>
        {{--<span class="home-chip home-chip--ghost"><i class="fa fa-award me-1"></i> Jornada de Ouro GT</span>--}}
      </div>
      
      <h2 class="home-hero__title">
        Sua jornada pela segurança <span>começa agora.</span>
      </h2>
      <p class="home-hero__subtitle">
        No SafetyStart, você aprende sobre percepção de risco de forma interativa. Complete módulos, ganhe conquistas e ajude a construir um ambiente de trabalho cada vez mais seguro para todos.
      </p>

      <div class="home-hero__cta">
        <a href="/conquistas" class="home-btn home-btn--light"><i class="fa fa-trophy me-2"></i>Minhas conquistas</a>
        <a href="/modulos" class="home-btn"><i class="fa fa-route me-2"></i>Começar trilha</a>
      </div>
    </div>

    <div class="home-hero__media">
        <img src="{{ asset('img/12.png') }}" alt="Ilustração de segurança no trabalho">
    </div>
    
  </section>

  {{-- Três ações principais --}}
  <section class="home-cards">
    <a href="/modulos" class="home-card bodyModulo1">
      <div class="home-card__tint"></div>
      <div class="home-card__icon"><i class="fa fa-book-open"></i></div>
      <h3 class="home-card__title">Trilha do conhecimento</h3>
      <p class="home-card__desc">
        Acesse os módulos, teste seus conhecimentos e avance na sua jornada de segurança. Cada etapa concluída é uma vitória para você e para nossa equipe.
      </p>
      <span class="home-card__cta">Começar trilha <i class="fa fa-arrow-right ms-2"></i></span>
    </a>

    <a href="/diarias" class="home-card bodyModulo4">
      <div class="home-card__tint"></div>
      <div class="home-card__icon"><i class="fa fa-calendar"></i></div>
      <h3 class="home-card__title">Desafio Diário</h3>
      <p class="home-card__desc">
        Teste seu conhecimento diariamente com uma nova pergunta. Responda certo e some pontos extras!
      </p>
      <span class="home-card__cta">Responder agora <i class="fa fa-arrow-right ms-2"></i></span>
    </a>

    <a href="/minutos" class="home-card bodyModulo3">
      <div class="home-card__tint"></div>
      <div class="home-card__icon"><i class="fa fa-stopwatch"></i></div>
      <h3 class="home-card__title">Minutos da Percepção</h3>
      <p class="home-card__desc">
        Pílulas de conhecimento para reforçar boas práticas e manter sua percepção de risco sempre em alta. Conteúdo rápido para um impacto duradouro.
      </p>
      <span class="home-card__cta">Abrir minutos <i class="fa fa-arrow-right ms-2"></i></span>
    </a>
  </section>

  <section class="home-leadership-intro">
    <h2 class="home-leadership-intro__title">Uma Mensagem da Nossa Liderança</h2>
    <p class="home-leadership-intro__text">
      A segurança é um compromisso de todos, começando pelos nossos líderes. Ouça a mensagem que os gestores de nossas plantas prepararam especialmente para você, reforçando a importância da sua participação nesta jornada.
    </p>
  </section>

  {{-- Vídeos dos gestores --}}
  <section class="home-videos">
    <div class="home-video">
      <h3 class="home-video__title">Alex - Plant Manager Mopar</h3>
      <div style="padding:75% 0 0 0;position:relative;">
        <iframe src="https://player.vimeo.com/video/1110186877?h=d5c126c81c&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" referrerpolicy="strict-origin-when-cross-origin" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Alex - Plant Manager Mopar"></iframe>
      </div>
      <script src="https://player.vimeo.com/api/player.js"></script>
    </div>

    <div class="home-video">
      <h3 class="home-video__title">Querlem - Plant Manager PWT</h3>
      <div style="padding:75% 0 0 0;position:relative;">
        <iframe src="https://player.vimeo.com/video/1110186957?h=76b0bfa1f0&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" referrerpolicy="strict-origin-when-cross-origin" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Querlem - Plant Manager PWT"></iframe>
      </div>
      <script src="https://player.vimeo.com/api/player.js"></script>
    </div>

    <div class="home-video">
      <h3 class="home-video__title">Valter - Plant Manager Veículos</h3>
      <div style="padding:75% 0 0 0;position:relative;">
        <iframe src="https://player.vimeo.com/video/1110187060?h=ea8837fab6&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture; clipboard-write; encrypted-media; web-share" referrerpolicy="strict-origin-when-cross-origin" style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Valter - Plant Manager Veículos"></iframe>
      </div>
      <script src="https://player.vimeo.com/api/player.js"></script>
    </div>
  </section>
</div>

{{-- ===== Estilos escopados (não alteram seu CSS existente) ===== --}}
<style>
  /* ESTILO PARA A NOVA SEÇÃO DE INTRODUÇÃO */
  .home-leadership-intro {
    text-align: center;
    max-width: 800px;
    margin: 40px auto 30px; /* Ajuste de margem para espaçamento */
  }

  .home-leadership-intro__title {
    font-size: 26px;
    font-weight: 900;
    color: var(--text, #1f2430);
    margin-bottom: 8px;
  }

  .home-leadership-intro__text {
    font-size: 16px;
    color: var(--muted, #5b6372);
    line-height: 1.6;
  }

  .home-videos {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 20px;
    /* margin-top: 30px; Removido para que a margem da nova seção controle o espaçamento */
  }

  @media (max-width: 768px) {
    .home-videos {
      grid-template-columns: 1fr;
    }
  }

  .home-video {
    background: #f7f9ff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 10px 20px rgba(0, 0, 0, .08);
  }

  .home-video__title {
    font-size: 20px;
    font-weight: bold;
    margin-bottom: 10px;
  }

  #home {
    --text: #1f2430;
    --muted: #5b6372;
    --accent: #1691ff;
    --brand: #07509D;
  }

  /* HERO base */
  .home-hero {
    position: relative;
    display: grid;
    grid-template-columns: 1fr 1fr; /* Alterado para colunas iguais */
    gap: 30px; /* Aumentado o espaçamento */
    align-items: center;
    padding: 20px;
    border-radius: 24px;
    overflow: hidden;
    margin-bottom: 26px;
  }

  .home-hero__content {
    position: relative;
    z-index: 1;
    padding: 8px;
  }

  /* NOVO: Estilos para a imagem do hero */
.home-hero__media {
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: -20px; /* Adiciona a borda negativa */
    overflow: hidden; /* Garante que a imagem não vaze para fora */
}

.home-hero__media img {
    max-width: 100%;
    height: auto;
    object-fit: contain;
}  
  /* HERO claro (tom de branco) */
  .home-hero--light {
    background: linear-gradient(180deg, #ffffff 0%, #f7f9ff 100%);
    border: 1px solid #e9edf6;
    box-shadow: 0 10px 26px rgba(0, 0, 0, .06);
    color: var(--text);
  }

  .home-hero--light .home-hero__title span {
    color: var(--brand);
  }

  .home-hero__title {
    margin: 2px 0 10px; /* Aumentei a margem inferior */
    font-size: 36px; /* Aumentei o tamanho da fonte */
    font-weight: 900;
    line-height: 1.15;
  }

  .home-hero__subtitle {
    margin: 0 0 18px; /* Aumentei a margem inferior */
    color: var(--muted);
    max-width: 55ch; /* Limitei um pouco a largura */
    font-size: 16px; /* Aumentei o tamanho da fonte */
    line-height: 1.6;
  }

  /* Chips */
  .home-hero__chips {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
    margin-bottom: 12px; /* Aumentei a margem inferior */
  }

  .home-chip {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-weight: 800;
    font-size: 12px;
    padding: 6px 10px;
    border-radius: 999px;
  }

  .home-chip--brand {
    background: #e8f1ff;
    color: #0b3b77;
    border: 1px solid #cfe3ff;
  }

  .home-chip--ghost {
    background: #f6f8ff;
    color: #394056;
    border: 1px solid #e9edf6;
  }

  /* CTAs */
  .home-hero__cta {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
  }

  .home-btn {
    background: var(--accent);
    color: #fff;
    border: none;
    border-radius: 999px;
    padding: 12px 22px; /* Aumentei o padding */
    font-size: 14px; /* Aumentei a fonte */
    font-weight: 900;
    letter-spacing: .2px;
    box-shadow: 0 10px 22px rgba(22, 145, 255, .18);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    transition: transform .15s ease, box-shadow .15s ease, filter .15s ease;
  }

  .home-btn:hover {
    transform: translateY(-2px); /* Efeito de hover mais pronunciado */
    box-shadow: 0 14px 28px rgba(22, 145, 255, .26);
    filter: brightness(1.05);
  }

  .home-btn--light {
    background: #ffffff;
    color: #1f2430;
    border: 1px solid #e5eaf5;
    box-shadow: 0 6px 14px rgba(0, 0, 0, .04);
  }
  
  .home-btn--light:hover {
      box-shadow: 0 10px 20px rgba(0, 0, 0, .08);
  }


  /* CARDS DE AÇÃO (grid) */
  .home-cards {
    --gap: 18px;
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: var(--gap);
  }

  @media (max-width: 1200px) {
    .home-cards {
      grid-template-columns: repeat(2, 1fr);
    }
  }

  @media (max-width: 640px) {
    .home-cards {
      grid-template-columns: 1fr;
    }
  }

  .home-card {
    position: relative;
    display: flex;
    flex-direction: column;
    text-decoration: none;
    color: #fff;
    border-radius: 20px;
    padding: 18px 18px 14px;
    min-height: 200px;
    border: 1px solid rgba(255, 255, 255, 0.10);
    box-shadow: 0 12px 26px rgba(0, 0, 0, .12), 0 6px 16px rgba(0, 0, 0, .10);
    transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
    overflow: hidden;
  }

  .home-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 18px 34px rgba(0, 0, 0, .16);
    border-color: rgba(255, 255, 255, .18);
  }

  .home-card__tint {
    position: absolute;
    inset: 0;
    background: linear-gradient(180deg, rgba(0, 0, 0, .06), rgba(0, 0, 0, .22));
  }

  .home-card__icon {
    position: relative;
    z-index: 1;
    width: 42px;
    height: 42px;
    border-radius: 12px;
    display: grid;
    place-items: center;
    background: rgba(0, 0, 0, .22);
    box-shadow: inset 0 0 0 1px rgba(255, 255, 255, .18);
    font-size: 20px;
    margin-bottom: 10px;
  }

  .home-card__title {
    position: relative;
    z-index: 1;
    margin: 0 0 6px;
    font-weight: 900;
  }

  .home-card__desc {
    position: relative;
    z-index: 1;
    margin: 0 0 12px;
    opacity: .95;
    flex-grow: 1; /* Faz a descrição ocupar o espaço para alinhar os botões */
  }

  .home-card__cta {
    position: relative;
    z-index: 1;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 8px 14px;
    border-radius: 999px;
    background: rgba(255, 255, 255, .16);
    box-shadow: inset 0 0 0 1px rgba(255, 255, 255, .24);
    font-weight: 800;
    letter-spacing: .2px;
    width: max-content;
  }

  /* Responsivo do hero */
  @media (max-width: 992px) {
    .home-hero {
      grid-template-columns: 1fr;
      text-align: center; /* Centraliza o texto no mobile */
    }

    .home-hero__subtitle {
      max-width: unset;
    }
    
    .home-hero__chips, .home-hero__cta {
        justify-content: center; /* Centraliza chips e botões */
    }
    
    .home-hero__media {
        margin-top: 20px;
    }
  }
</style>

@endsection