<x-guest-layout>
    <x-jet-authentication-card>
        
        <x-slot name="logo">
            <img src="img/logos.png">
        </x-slot>

        <x-jet-validation-errors class="mb-4" />

        @if (session('status'))
            <div class="mb-4 font-medium text-sm text-green-600">
                {{ session('status') }}
            </div>
        @endif

        <form method="POST" action="{{ route('login') }}">
            @csrf
            
            <div>
                <label for="email" class="block text-sm/6 font-semibold text-white">E-mail</label>
                <div class="mt-2.5">
                    <input id="email" type="text" name="email" placeholder="Digite seu e-mail" :value="old('email')" required autofocus class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600">
                </div>
            </div>

            <div class="mt-4">
                <label for="password" class="block text-sm/6 font-semibold text-white">Senha</label>
                <div class="mt-2.5">
                    <x-jet-input id="password" placeholder="Digite sua senha" type="password" name="password" required autocomplete="current-password" class="block w-full rounded-md bg-white px-3.5 py-2 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-indigo-600" />                    
                </div>
            </div>

            <div class="mt-4">
                <div class="flex items-center justify-end mt-4">
                    @if (Route::has('password.request'))
                    <a class="underline text-sm text-white hover:text-white" href="{{ route('password.request') }}">
                        {{ __('Esqueceu sua senha?') }}
                    </a>
                    @endif
                </div>

            </div>
            
            <div class="flex items-center justify-center mt-4">
                <x-jet-button class="ml-4 bg-cyan">
                    {{ __('ENTRAR') }}
                </x-jet-button>
            </div>
        </form>
        
        <span class="flex items-center justify-center mt-10 text-white">É seu primeiro acesso?</span>

        <div class="flex items-center justify-center mt-2">
            <x-jet-button class="ml-4 bg-yellow">
                @if (Route::has('register'))
                    <a href="{{ route('register') }}">
                        {{ __('CADASTRE-SE AQUI') }}
                    </a>
                @endif
            </x-jet-button>
        </div>
        
    </x-jet-authentication-card>
</x-guest-layout>
