document.addEventListener('DOMContentLoaded', function () {
    const sidebar = document.getElementById('sidebar');
    const content = document.getElementById('content');
    const main = document.getElementById('main');
    const showBtn = document.getElementById('showSidebarBtn');
    const hideBtn = document.getElementById('hideSidebarBtn');

    function ajustarSidebarParaTela() {
        const isMobile = window.innerWidth <= 768;
        const isSidebarVisible = sidebar.style.display !== 'none';

        if (isMobile) {
            sidebar.style.display = 'none';
            content.style.width = '100%';
            main.style.marginLeft = isSidebarVisible ? '0' : '0';
            showBtn.style.display = 'inline-block';
            hideBtn.style.display = 'none';
        } 
        // else {
        //     sidebar.style.display = isSidebarVisible ? 'block' : 'none';
        //     main.style.marginLeft = isSidebarVisible ? '320px' : '0';
        //     showBtn.style.display = 'inline-block';
        //     hideBtn.style.display = isSidebarVisible ? 'inline-block' : 'none';
        // }
    }

    showBtn.addEventListener('click', () => {
        sidebar.style.display = 'block';
        content.style.width = window.innerWidth <= 768 ? '100%' : '100%';
        showBtn.style.display = 'none';
        hideBtn.style.display = 'inline-block';
    });

    hideBtn.addEventListener('click', () => {
        sidebar.style.display = 'none';
        content.style.width = '100%';
        main.style.marginLeft = '0';
        showBtn.style.display = 'inline-block';
        hideBtn.style.display = 'none';
    });

    ajustarSidebarParaTela();
    window.addEventListener('resize', ajustarSidebarParaTela);
});

document.addEventListener('DOMContentLoaded', function() {
    const modalBody = document.querySelector('.modal-body');
    const checkboxes = Array.from(modalBody.children);
    
    // Função para embaralhar o array
    for (let i = checkboxes.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [checkboxes[i], checkboxes[j]] = [checkboxes[j], checkboxes[i]];
    }

    // Remove todos os filhos e adiciona na nova ordem
    checkboxes.forEach(checkbox => {
        modalBody.appendChild(checkbox);
    });
});

document.addEventListener('DOMContentLoaded', function() {
    const checkboxes = document.querySelectorAll('#exampleModal input[type="checkbox"]');

    checkboxes.forEach((checkbox) => {
        checkbox.addEventListener('change', function() {
            if (this.checked) {
                checkboxes.forEach((cb) => {
                    if (cb !== this) cb.checked = false;
                });
            }
        });
    });
});
