<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAtosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('atos', function (Blueprint $table) {
            $table->id('ato_id'); // chave primária
            $table->unsignedBigInteger('usu_id');
            $table->string('usu_nome_completo');
            $table->string('usu_planta');
            $table->text('ato_acao')->nullable();
            $table->text('ato_problema')->nullable();
            $table->string('ato_equipe')->nullable();
            $table->text('ato_condicao')->nullable();
            $table->text('ato_solucao')->nullable();
            $table->dateTime('ato_datetime');
            $table->timestamps();
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('atos');
    }
}
