<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->foreignId('current_team_id')->nullable();
            $table->string('profile_photo_path', 2048)->nullable();
            $table->timestamps();
            $table->boolean('usu_resp_mod1')->default(false);
            $table->boolean('usu_resp_mod2')->default(false);
            $table->boolean('usu_resp_mod3')->default(false);
            $table->boolean('usu_resp_mod4')->default(false);
            $table->boolean('usu_resp_mod5')->default(false);
            $table->boolean('usu_resp_dia1')->default(false);
            $table->boolean('usu_resp_dia2')->default(false);
            $table->boolean('usu_resp_dia3')->default(false);
            $table->boolean('usu_resp_dia4')->default(false);
            $table->boolean('usu_resp_dia5')->default(false);
            $table->timestamp('usu_resp_dia1_data')->nullable();
            $table->timestamp('usu_resp_dia2_data')->nullable();
            $table->timestamp('usu_resp_dia3_data')->nullable();
            $table->timestamp('usu_resp_dia4_data')->nullable();
            $table->timestamp('usu_resp_dia5_data')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
