<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

class UsuarioPerfil extends Component
{
    public $nomePerfil;
    public $emailPerfil;
    public $empresa;

    public function mount()
    {
        sleep(1); // simula tempo de carregamento
        $user = Auth::user();
        $this->nomePerfil = $user->name;
        $this->emailPerfil = $user->email;
        $this->empresa = $user->empresa;
    }

    public function atualizar()
    {
        $this->validate([
            'nomePerfil' => 'required|string|max:255',
            'empresa' => 'required|string|max:255',
        ]);
    
        /** @var \App\Models\User $user */
        $user = Auth::user();
        $user->name = $this->nomePerfil;
        $user->empresa = $this->empresa;
        $user->save();
    
        session()->flash('success', 'Dados atualizados com sucesso!');
    }

    public function render()
    {
        //dd($this->nomePerfil, $this->empresa); // só para testar
        return view('livewire.usuario-perfil');
    }
}
