<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Schema;
use App\Models\Log; // Adicionar a importação do modelo Log

class MinutosController extends Controller
{
    /**
     * Marca um "minuto" como concluído para o usuário logado.
     * Ex.: minuto=1 -> atualiza users.usu_min1 = 1
     */

    /**
     * Avalia o minuto com uma nota de 1 a 5
     */
    public function avaliar(Request $request, int $minuto)
    {
        // Obter o usuário logado
        $user = Auth::user();

        // Verificar se o usuário já avaliou
        $campo = 'usu_min' . $minuto;
        if ($user->$campo) {
            return back()->with('error', 'Você já avaliou este minuto.');
        }

        // Validar a nota (deve ser um número entre 1 e 5)
        $request->validate([
            'nota' => 'required|integer|between:1,5',
        ]);

        // Capturar a nota do formulário
        $nota = $request->input('nota');

        // Atualizar a nota no campo correspondente (usu_minX)
        $user->$campo = $nota;

        // Salvar as alterações no banco de dados
        $user->save();

        // Registrar o log da avaliação
        Log::create([
            'usu_id' => $user->id,
            'log_ip' => request()->ip(),
            'log_acao' => "avaliou o minuto {$minuto} com a nota {$nota}",
            'usu_email' => $user->email,
        ]);

        // Retornar uma resposta de sucesso
        return back()->with('success', "Sua avaliação foi registrada com sucesso!");
    }
}
