<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ato;
use Illuminate\Support\Facades\Auth;

class AtoController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'tipoCondicao' => 'required|string',
            'equipeCondicao' => 'nullable|string',
            'descricaoCondicao' => 'nullable|string',
            'solucaoCondicao' => 'nullable|string',
            'problemaCondicao' => 'nullable|string',
        ]);

        Ato::create([
            'usu_id' => Auth::id(),
            'usu_nome_completo' => Auth::user()->name,
            'usu_planta' => Auth::user()->empresa, // ou pegue de outra forma se necessário
            'ato_acao' => $request->tipoCondicao,
            'ato_problema' => $request->problemaCondicao,
            'ato_equipe' => $request->equipeCondicao,
            'ato_condicao' => $request->descricaoCondicao,
            'ato_solucao' => $request->solucaoCondicao,
            'ato_datetime' => now(),
        ]);

        return redirect('/atos')->with('success', 'Registro enviado com sucesso!');
    }
}
