<?php

namespace App\Actions\Fortify;

use App\Models\User;
use App\Models\Log; // Certifique-se de ter o modelo Log importado
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use Laravel\Jetstream\Jetstream;

class CreateNewUser implements CreatesNewUsers
{
    use PasswordValidationRules;

    /**
     * Validate and create a newly registered user.
     *
     * @param  array  $input
     * @return \App\Models\User
     */
    public function create(array $input)
    {
        // Validação do campo 'email' substituído por 'text' (campo de texto comum)
        Validator::make($input, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'max:255', 'unique:users'],
            'empresa' => ['nullable', 'string', 'max:100'],
            'password' => $this->passwordRules(),
            'terms' => Jetstream::hasTermsAndPrivacyPolicyFeature() ? ['accepted', 'required'] : '',
        ])->validate();

        // Criação do usuário
        $user = User::create([
            'name' => $input['name'],
            'email' => $input['email'],
            'empresa' => $input['empresa'] ?? null,
            'password' => Hash::make($input['password']),
        ]);

        // Inserir o log na tabela 'logs'
        Log::create([
            'usu_id' => $user->id, // ID do usuário
            'log_ip' => request()->ip(), // IP do usuário
            'log_acao' => 'criou seu usuário', // Ação realizada
            'usu_email' => $input['email'], // Email do usuário
        ]);

        return $user;
    }
}
